//======================================================================
/**
 * @file	btlv_particle.h
 * @brief	og` p[eBN
 * @author	ariizumi
 * @data	11/06/28
 */
//======================================================================
#pragma once

#include "btlv_types.h"

namespace btl
{

typedef struct
{
  gfl::fs::ArcFile::ARCDATID arcId;
}ParticleInitParam;

class BtlvParticle:public BtlvObject
{
GFL_FORBID_COPY_AND_ASSIGN(BtlvParticle);

public:
  BtlvParticle( const ParticleInitParam &initParam , BattleViewSystem *core );
  ~BtlvParticle();

  void Update(void);
  

  void SetLifeTime(int time){mLifeTime = time;}
  bool IsFinish(void){return (mLifeTime == 0);}

  //FX肻Ȃ̂public
  nw::ut::LinkListNode mNode;

private:

  BattleViewSystem *mBtlvCore;
  
  int mLifeTime;

  gfl::grp::g3d::G3DPTCParticle mParticle;
  gfl::grp::g3d::Resource       *mRes;


};

} //namespace btl
