//======================================================================
/**
 * @file	btlv_particle.h
 * @brief	og` p[eBN
 * @author	ariizumi
 * @data	11/06/28
 */
//======================================================================
#include <gflib.h>
#include "btlv_core.h"
#include "btlv_particle.h"


namespace btl
{

BtlvParticle::BtlvParticle( const ParticleInitParam &initParam , BattleViewSystem *core )
:BtlvObject()
,mBtlvCore(core)
,mLifeTime(-1)
{

//  gfl::debug::SetPrintFlag( gfl::debug::PRINT_FLAG_LEVEL3|gfl::debug::PRINT_FLAG_CATEGORY_HEAP );

  gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
  gfl::heap::HeapBase *deviceMem = mBtlvCore->GetDeviceMem();
  gfl::heap::NwAllocator *heapAllocater = mBtlvCore->GetNwAllocaterHeap();
  gfl::heap::NwAllocator *deviceAllocater = mBtlvCore->GetNwAllocaterDevice();

  gfl::grp::g3d::Scene *scene = mBtlvCore->GetScene();
  gfl::fs::ArcFile *arc = mBtlvCore->GetArcModel();

  u32 resFlg = gfl::grp::g3d::Resource::COMMON_RESOURCE_NONE;
  resFlg |= gfl::grp::g3d::Resource::COMMON_RESOURCE_PARTICLE_DEFAULT_SHADER_BIT;

  gfl::grp::g3d::Resource::Description desc;
  //desc.texture_location_flag = gfl::grp::MEMORY_AREA_VRAMB | gfl::grp::MEMORY_TRANSFER_NO_COPY_FCRAM_DMP;

  mRes = GFL_NEW(deviceMem) gfl::grp::g3d::Resource;
  mRes->LoadAndSetup(deviceAllocater,arc,initParam.arcId,&desc,resFlg);

  mParticle.Create(heapAllocater,deviceAllocater,mRes);

  scene->AddParticleToSceneCalculateGroup( &mParticle, BTLV_SCENE_NORMAL );
  scene->RemoveParticleFromSceneDrawGroup( &mParticle, BTLV_SCENE_NORMAL );
  scene->AddParticleToSceneDrawGroup( &mParticle, BTLV_SCENE_PARTICLE );

  scene->Initialize();
  
  gfl::debug::ResetPrintFlag();
}

BtlvParticle::~BtlvParticle()
{
  gfl::grp::g3d::Scene *scene = mBtlvCore->GetScene();

  GFL_PRINT("DEL\n");

  scene->RemoveParticleFromSceneCalculateGroup( &mParticle );
  scene->Initialize();
  GFL_DELETE mRes;
}


void BtlvParticle::Update(void)
{
  if( IsUpdate() == true )
  {
    gfl::math::VEC3 pos = GetPosition()+GetOffset(); 
    mParticle.SetRotateXYZ(GetRotate());
    mParticle.SetTranslate(pos);
    mParticle.SetScale(GetScale());
    ResetFlg();
  }
  
  if( mLifeTime > 0 )
  {
    mLifeTime--;
  }
}

}//namespace btl
