
#include <sound/TemporarySoundSystem.h>

namespace snd
{

  TemporarySoundSystem::TemporarySoundSystem( 
      gfl::heap::HeapBase* heap, gfl::snd::SoundSystem* sound_system ) : 
    m_request_queue( heap, REQUEST_QUEUE_SIZE ),
    m_state( REQUEST_WAIT ),
    m_remaining_fade_frame( 0 ),
    m_sound_system( sound_system )
  {
  }



  TemporarySoundSystem::~TemporarySoundSystem()
  {
  }




  void TemporarySoundSystem::Update( void )
  {
    if( m_state == REQUEST_WAIT ) {
      if( m_request_queue.IsEmpty() == false ) {
        RequestData head_request = m_request_queue.Dequeue();
        this->ProcessRequest( head_request );
      }
      if( 0 < m_remaining_fade_frame ) {
        m_state = FADE_WAIT;
      }
    }
    else if( m_state == FADE_WAIT ) {
      if( 0 < m_remaining_fade_frame ) {
        m_remaining_fade_frame--;
      }
      if( m_remaining_fade_frame <= 0 ) {
        m_state = REQUEST_WAIT;
      }
    }
  }



  void TemporarySoundSystem::ProcessRequest( const RequestData& request )
  {
    switch( request.type ) {
    case PLAY:
      m_sound_system->Play( request.sound_handle_index, request.sound_item_id, request.fade_frame );
      if( 0 < request.fade_frame ) {
        m_remaining_fade_frame = request.fade_frame;
      }
      break;

    case STOP:
      m_sound_system->Stop( request.sound_handle_index, request.fade_frame );
      if( 0 < request.fade_frame ) {
        m_remaining_fade_frame = request.fade_frame;
      }
      break;

    case PAUSE:
      m_sound_system->Pause( request.sound_handle_index, true, request.fade_frame );
      if( 0 < request.fade_frame ) {
        m_remaining_fade_frame = request.fade_frame;
      }
      break;

    case PAUSE_RELEASE:
      m_sound_system->Pause( request.sound_handle_index, false, request.fade_frame );
      if( 0 < request.fade_frame ) {
        m_remaining_fade_frame = request.fade_frame;
      }
      break;

    default:
      GFL_ASSERT(0);
      break;
    }
  }




  // ŏ̃tB[hBGM
  void TemporarySoundSystem::StartFieldBgm_AtFirst( u32 sound_item_id )
  {
    if( m_request_queue.IsFull() == false ) {
      RequestData stop_request = { STOP, HANDLE_TITLE_BGM, sound_item_id, 30 };
      m_request_queue.Enqueue( stop_request );
    }

    if( m_request_queue.IsFull() == false ) {
      RequestData play_request = { PLAY, HANDLE_FIELD_BGM, sound_item_id, 30 };
      m_request_queue.Enqueue( play_request );
    }
  }

  // ogÃtB[hBGM
  void TemporarySoundSystem::StartFieldBgm_FromBattle( void )
  {
    if( m_request_queue.IsFull() == false ) {
      RequestData stop_request = { STOP, HANDLE_BATTLE_BGM, 0, 30 };
      m_request_queue.Enqueue( stop_request );
    }

    if( m_request_queue.IsFull() == false ) {
      RequestData release_request = { PAUSE_RELEASE, HANDLE_FIELD_BGM, 0, 30 };
      m_request_queue.Enqueue( release_request );
    }
  } 

  // ][`FW̃tB[hBGM
  void TemporarySoundSystem::ChangeFieldBgm_ByZoneChange( u32 sound_item_id )
  {
    if( m_request_queue.IsFull() == false ) {
      RequestData stop_request = { STOP, HANDLE_FIELD_BGM, sound_item_id, 30 };
      m_request_queue.Enqueue( stop_request );
    }

    if( m_request_queue.IsFull() == false ) {
      RequestData play_request = { PLAY, HANDLE_FIELD_BGM, sound_item_id, 0 };
      m_request_queue.Enqueue( play_request );
    }
  }


  // ogBGM
  void TemporarySoundSystem::StartBattleBgm( u32 sound_item_id )
  {
    if( m_request_queue.IsFull() == false ) {
      RequestData pause_request = { PAUSE, HANDLE_FIELD_BGM, sound_item_id, 12 };
      m_request_queue.Enqueue( pause_request );
    }

    if( m_request_queue.IsFull() == false ) {
      RequestData play_request = { PLAY, HANDLE_BATTLE_BGM, sound_item_id, 0 };
      m_request_queue.Enqueue( play_request );
    }
  }

} // namespace snd
