#ifndef __TEMPORARYSOUNDSYSTEM_H__
#define __TEMPORARYSOUNDSYSTEM_H__
#include <gflib.h> 

namespace snd
{
  class TemporarySoundSystem
  {
    public:

      TemporarySoundSystem( gfl::heap::HeapBase* heap, gfl::snd::SoundSystem* sound_system );
      ~TemporarySoundSystem();

      void Update( void );
      void StartFieldBgm_AtFirst( u32 sound_item_id );
      void StartFieldBgm_FromBattle( void );
      void ChangeFieldBgm_ByZoneChange( u32 sound_item_id );
      void StartBattleBgm( u32 sound_item_id );


    private:

      enum HandleIndex {
        HANDLE_TITLE_BGM,
        HANDLE_SE,
        HANDLE_FIELD_BGM,
        HANDLE_BATTLE_BGM,
        HANDLE_NUM,
      };

      enum RequestType {
        PLAY,
        STOP,
        PAUSE,
        PAUSE_RELEASE,
      };

      enum State {
        REQUEST_WAIT,
        FADE_WAIT,
      };

      struct RequestData {
        RequestType type;
        u32 sound_handle_index;
        u32 sound_item_id;
        u32 fade_frame;
      };

      static const u32 REQUEST_QUEUE_SIZE = 128;
      gfl::base::Queue<RequestData> m_request_queue;
      State m_state;
      u32 m_remaining_fade_frame;
      gfl::snd::SoundSystem* m_sound_system;


      void ProcessRequest( const RequestData& request );
  };
} // namespace snd

#endif // __TEMPORARYSOUNDSYSTEM_H__
