//[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[[
/**
 *	GAME FREAK inc.
 *
 *	@file		FieldBuildModel.cpp
 *	@brief  zuf
 *	@author	tomoya takahashi
 *	@date		2011.06.27
 *
 */
//]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]]


#include "FieldBuildModel.h"


namespace field{

//-----------------------------------------------------------------------------
/**
 *					萔錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					NX錾
*/
//-----------------------------------------------------------------------------

//-----------------------------------------------------------------------------
/**
 *					
*/
//-----------------------------------------------------------------------------
//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
BuildModelManager::BuildModelManager(void) : 
  m_pHeap(NULL),
  m_pDevice(NULL),
  m_AreaID(0),
  m_pGraphics(NULL),
  m_pArcData(NULL),
  m_pArcTex(NULL),
  m_pArcMdl(NULL),
  m_pArcAnm(NULL),
  m_pData(NULL),
  m_pTextureResource(NULL),
  m_pMdlResourceArray(NULL),
  m_pAnimResourceArray(NULL),
  m_BuildModelNum(0),
  m_pModelArray(NULL),
  m_ModelMax(0)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
BuildModelManager::~BuildModelManager()
{
  this->Finalize();
}


//----------------------------------------------------------------------------
/**
 *	@brief  
 *
 *	@param	p_heap          q[vx[X
 *	@param  p_device        foCXAP[^
 *	@param  buildModelMax   zufő吔
 *	@param  areaID          GAID
 *	@param  p_graphics      OtBbNX
 */
//-----------------------------------------------------------------------------
void BuildModelManager::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device, u32 buildModelMax, u32 areaID, Graphics* p_graphics )
{
  // ۑׂۑ
  m_pHeap       = p_heap;
  m_pDevice     = p_device;
  m_AreaID      = areaID;
  m_pGraphics   = p_graphics;

  // A[JCu
  m_pArcData  = GFL_NEW(m_pHeap) gfl::fs::ArcFile( L"rom:/field_bm_dat.garc" );
  m_pArcTex   = GFL_NEW(m_pHeap) gfl::fs::ArcFile( L"rom:/field_bm_tex.garc" );
  m_pArcMdl   = GFL_NEW(m_pHeap) gfl::fs::ArcFile( L"rom:/field_bm_mdl.garc" );
  m_pArcAnm   = GFL_NEW(m_pHeap) gfl::fs::ArcFile( L"rom:/field_bm_anm.garc" );

  // f[N
  m_pModelArray = GFL_NEW(m_pHeap) BuildModel[ buildModelMax ];
  m_ModelMax    = buildModelMax;

  // GAzuf̓ǂݍ
  this->LoadAreaData();
  
  // GAAzuf\[Xǂݍ
  this->LoadResource();

}

//----------------------------------------------------------------------------
/**
 *	@brief    j
 */
//-----------------------------------------------------------------------------
void BuildModelManager::Finalize( void )
{
  if(m_pModelArray){
    // fSj
    for( u32 i=0; i<m_ModelMax; ++i ){
      m_pModelArray[i].Finalize();
    }
    GFL_DELETE_ARRAY m_pModelArray;
    m_pModelArray = NULL;
    
    this->DeleteResource();
    this->DeleteAreaData();

    // A[JCuj
    GFL_DELETE m_pArcData;
    m_pArcData = NULL;
    GFL_DELETE m_pArcTex;
    m_pArcTex = NULL;
    GFL_DELETE m_pArcMdl;
    m_pArcMdl = NULL;
    GFL_DELETE m_pArcAnm;
    m_pArcAnm = NULL;
  }
}


//----------------------------------------------------------------------------
/**
 *	@brief  XV
 */
//-----------------------------------------------------------------------------
void BuildModelManager::Update( skybox::PeriodType timezone )
{
  // f̃Abvf[g
  for( u32 i=0; i<m_ModelMax; ++i ){
    m_pModelArray[i].Update( timezone );
  }
}


//----------------------------------------------------------------------------
/**
 *	@brief  f̐
 *
 *	@param	blockIdx  o^ubNCfbNX
 *	@param  bm_id     zufID
 *	@param  pos       W
 */
//-----------------------------------------------------------------------------
void BuildModelManager::CreateModel( u32 blockIdx, u32 bm_id, const gfl::math::VEC3& pos )
{
  BuildModel* p_model = this->GetClearWork();
  u32 mdl_index = this->GetBMIDToIndex( bm_id );
  
  // f
  p_model->Initialize( m_pHeap, m_pDevice, m_pGraphics, blockIdx, &m_pMdlResourceArray[mdl_index], &m_pAnimResourceArray[mdl_index] );
  p_model->SetTranslate( pos );
}

//----------------------------------------------------------------------------
/**
 *	@brief  o^Ă郂fSj
 *
 *	@param	blockIdx  o^ubNCfbNX
 */
//-----------------------------------------------------------------------------
void BuildModelManager::DeleteModelAll( u32 blockIdx )
{
  // blockIdx̃fj
  for( u32 i=0; i<m_ModelMax; ++i ){
    if( m_pModelArray[i].IsDataIn() ){
      if( m_pModelArray[i].GetBlockIndex() == blockIdx ){
        m_pModelArray[i].Finalize();
      }
    }
  }
}


//----------------------------------------------------------------------------
/**
 *	@brief  Ă郏[N̎擾
 *
 *	@return [N
 */
//-----------------------------------------------------------------------------
BuildModel* BuildModelManager::GetClearWork( void )
{
  for( u32 i=0; i<m_ModelMax; ++i ){
    if( !m_pModelArray[i].IsDataIn() ){
      return  &m_pModelArray[i];
    }
  }

  GFL_ASSERT_STOP(0);
  return NULL;
}

//----------------------------------------------------------------------------
/**
 *	@brief  bm_id̃GACfbNX擾
 *
 *	@param	bm_id
 *
 *	@return GAfCfbNX
 */
//-----------------------------------------------------------------------------
u32 BuildModelManager::GetBMIDToIndex( u32 bm_id ) const
{
  for( u32 i=0; i<m_pData->build_model_num; ++i ){
    
    if( m_pData->data[i].bm_id == bm_id ){
      return i;
    }
  }

  GFL_ASSERT_STOP(0);
  return 0;
}



//----------------------------------------------------------------------------
/**
 *	@brief  GAzuf[^ǂݍ
 */
//-----------------------------------------------------------------------------
void BuildModelManager::LoadAreaData( void )
{
  // f[^ǂݍ
  size_t datasize = m_pArcData->GetDataSize( m_AreaID );
  m_pData = reinterpret_cast<BuildModelAreaData*>(GflHeapAllocMemory( m_pHeap, datasize ));
  m_pArcData->LoadData( m_AreaID, m_pData );
}

//----------------------------------------------------------------------------
/**
 *	@brief  GAzuf[^
 */
//-----------------------------------------------------------------------------
void BuildModelManager::DeleteAreaData( void )
{
  if(m_pData){
    GflHeapFreeMemory( m_pData );
    m_pData = NULL;
  }
}


//----------------------------------------------------------------------------
/**
 *	@brief  GAzuf[^@\[Xǂݍ
 */
//-----------------------------------------------------------------------------
void BuildModelManager::LoadResource( void )
{
  bool result;
  
  GFL_ASSERT( m_pData );
  
  // O[oeNX`
  m_pTextureResource = GFL_NEW(m_pHeap) gfl::grp::g3d::Resource( m_pDevice, m_pArcTex, m_pData->area_tex_id );

  // ff[^,Ajf[^
  m_pMdlResourceArray = GFL_NEW( m_pHeap ) gfl::grp::g3d::Resource[ m_pData->build_model_num ];
  m_pAnimResourceArray = GFL_NEW( m_pHeap ) gfl::grp::g3d::Resource[ m_pData->build_model_num ];
  for( u32 i=0; i<m_pData->build_model_num; ++i ){
    // ff[^
    m_pMdlResourceArray[i].Load( m_pDevice, m_pArcMdl, m_pData->data[i].bm_id );

    m_pMdlResourceArray[i].Setup( m_pDevice, m_pTextureResource );
    result = m_pMdlResourceArray[i].Setup( m_pDevice );
    GFL_ASSERT_STOP( result );

    // Ajf[^
    m_pAnimResourceArray[i].Load( m_pDevice, m_pArcMdl, m_pData->data[i].anime_index );
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  GAzuf[^@\[Xj
 */
//-----------------------------------------------------------------------------
void BuildModelManager::DeleteResource( void )
{
  // ff[^AAjf[^j
  for( u32 i=0; i<m_pData->build_model_num; ++i ){
  
    // ff[^
    m_pMdlResourceArray[i].Unload();

    // Ajf[^
    m_pAnimResourceArray[i].Unload();
    
  }

  GFL_DELETE_ARRAY m_pMdlResourceArray;
  m_pMdlResourceArray = NULL;

  GFL_DELETE_ARRAY m_pAnimResourceArray;
  m_pAnimResourceArray = NULL;

  // O[oeNX`
  GFL_DELETE m_pTextureResource;
  m_pTextureResource = NULL;
}




//-----------------------------------------------------------------------------
/**
 *
 */
//-----------------------------------------------------------------------------


//----------------------------------------------------------------------------
/**
 *	@brief  RXgN^
 */
//-----------------------------------------------------------------------------
BuildModel::BuildModel( void ) :
  m_DataIn(false),
  m_BlockIndex(0),
  m_pModel(NULL)
{
}

//----------------------------------------------------------------------------
/**
 *	@brief  fXgN^
 */
//-----------------------------------------------------------------------------
BuildModel::~BuildModel()
{
  this->Finalize();
}


//----------------------------------------------------------------------------
/**
 *	@brief    
 *
 *	@param	p_heap        q[v[N
 *	@param	p_device      foCXAP[^
 *	@param  p_graphics    OtBbNX
 *	@param  blockIdx      o^ubNCfbNX
 *  @param  p_mdl         f\[X
 *  @param  p_anime       Aj[V\[X
 */
//-----------------------------------------------------------------------------
void BuildModel::Initialize( gfl::heap::HeapBase* p_heap, gfl::heap::NwAllocator* p_device, Graphics* p_graphics, u32 blockIdx, gfl::grp::g3d::Resource* p_mdl, gfl::grp::g3d::Resource* p_anime )
{
  // o^ubNCfbNXۑ
  m_BlockIndex = blockIdx;
  
  // f쐬
  m_pModel = GFL_NEW(p_heap) gfl::grp::g3d::Model;
  m_pModel->Create( p_device, p_device, p_mdl, 0 );
  
  // Aj[V\[X
  for( u32 i=0; i<BuildModelManager::BUILDANIME_IDX_MAX; ++i ){
    m_pResAnime[i] = GFL_NEW( p_heap ) gfl::grp::g3d::ResAnim();
    
    switch( i ){
    case BuildModelManager::BUILDANIME_IDX_ALLTIME: // SԂœAj Material
      if(p_anime->GetMaterialAnimsCount() > 0){
        m_pResAnime[i]->Create( p_device, p_anime, 0, gfl::grp::g3d::ResAnim::TYPE_MATERIAL );
        m_AnimeFlag[i] = true;
        m_pModel->ChangeAnimation( p_device, m_pResAnime[i], 0, i );
      }
      else{
        m_AnimeFlag[i] = false;
      }
      break;
    case BuildModelManager::BUILDANIME_IDX_NIGHT:       // 铮Aj   Visible
      if(p_anime->GetVisibilityAnimsCount() > 0){
        m_pResAnime[i]->Create( p_device, p_anime, 0, gfl::grp::g3d::ResAnim::TYPE_VISIBILITY );
        m_AnimeFlag[i] = true;
        m_pModel->ChangeAnimation( p_device, m_pResAnime[i], 0, i );
      }
      else{
        m_AnimeFlag[i] = false;
      }
      break;
    case BuildModelManager::BUILDANIME_IDX_NIGHT2:      // 铮Aj2  Material
      if(p_anime->GetMaterialAnimsCount() > 1){
        m_pResAnime[i]->Create( p_device, p_anime, 1, gfl::grp::g3d::ResAnim::TYPE_MATERIAL );
        m_AnimeFlag[i] = true;
        m_pModel->ChangeAnimation( p_device, m_pResAnime[i], 0, i );
      }
      else{
        m_AnimeFlag[i] = false;
      }
      break;
    case BuildModelManager::BUILDANIME_IDX_NIGHT3:      // 铮Aj3  Skeleton
      if(p_anime->GetSkeletalAnimsCount() > 0){
        m_pResAnime[i]->Create( p_device, p_anime, 0, gfl::grp::g3d::ResAnim::TYPE_SKELETAL );
        m_AnimeFlag[i] = true;
        m_pModel->ChangeAnimation( p_device, m_pResAnime[i], 0, i );
      }
      else{
        m_AnimeFlag[i] = false;
      }
      break;
    }
  }

  // 
  {
    gfl::grp::g3d::Scene* p_scene = p_graphics->GetScene();
    m_pScene = p_scene;
    p_scene->AddSceneNode( m_pModel );
  }
  
  // 
  m_TimeZone = skybox::PERIOD_TYPE_MORNING;
  
  m_DataIn = true;
}


//----------------------------------------------------------------------------
/**
 *	@brief  j
 */
//-----------------------------------------------------------------------------
void BuildModel::Finalize( void )
{
  if( m_DataIn ){
    m_DataIn = false;

    // V[j
    m_pScene->RemoveSceneNode( m_pModel );
    
    // fj
    GFL_DELETE m_pModel;
    m_pModel = NULL;


    for( u32 i=0; i<BuildModelManager::BUILDANIME_IDX_MAX; ++i ){
      
      GFL_DELETE m_pResAnime[i];
      m_pResAnime[i] = NULL;
    }
    
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  fAj[VXV
 */
//-----------------------------------------------------------------------------
void BuildModel::Update( skybox::PeriodType timezone )
{
  if( !this->IsDataIn() ){
    return ;
  }
  
  // 邾̃Aj[VONEOFF
  if( timezone != m_TimeZone ){

    // 
    if( ( (m_TimeZone == skybox::PERIOD_TYPE_MORNING) ||
        (m_TimeZone == skybox::PERIOD_TYPE_DAYTIME) ||
        (m_TimeZone == skybox::PERIOD_TYPE_DAYTIME_TO_EVENING) ) &&
        ( (timezone == skybox::PERIOD_TYPE_NIGHT) ||
        (timezone == skybox::PERIOD_TYPE_EVENING) ||
        (timezone == skybox::PERIOD_TYPE_EVENING_TO_NIGHT) )
        ){
      // AjN
      for( u32 i=BuildModelManager::BUILDANIME_IDX_NIGHT; i<BuildModelManager::BUILDANIME_IDX_MAX; ++i ){
        m_pModel->SetAnimationStepFrame( 1.0, i );
      }
    }
    else if( ( (m_TimeZone == skybox::PERIOD_TYPE_NIGHT) ||
        (m_TimeZone == skybox::PERIOD_TYPE_EVENING) ) &&
        ( (timezone == skybox::PERIOD_TYPE_MORNING) ||
        (timezone == skybox::PERIOD_TYPE_DAYTIME) ||
        (m_TimeZone == skybox::PERIOD_TYPE_NIGHT_TO_MORNING) ) ){

      // Aj~
      for( u32 i=BuildModelManager::BUILDANIME_IDX_NIGHT; i<BuildModelManager::BUILDANIME_IDX_MAX; ++i ){
        m_pModel->SetAnimationStepFrame( 0.0f, i );
        m_pModel->SetAnimationFrame( 0.0f, i );
      }
    }

    m_TimeZone = timezone;
  }
}

//----------------------------------------------------------------------------
/**
 *	@brief  f[^L̃`FbN
 */
//-----------------------------------------------------------------------------
bool BuildModel::IsDataIn(void) const
{
  return m_DataIn;
}


//----------------------------------------------------------------------------
/**
 *	@brief  ubNCfbNX擾
 *
 *	@return ubNCfbNX
 */
//-----------------------------------------------------------------------------
u32 BuildModel::GetBlockIndex( void ) const
{
  return m_BlockIndex;
}

//----------------------------------------------------------------------------
/**
 *	@brief  W̐ݒ
 *
 *	@param	pos
 */
//-----------------------------------------------------------------------------
void BuildModel::SetTranslate( const gfl::math::VEC3& pos )
{
  m_pModel->SetTranslate( pos );
}



} // namespace field
