//======================================================================
/**
 * @file	btlv_wait_camera.cpp
 * @brief	og` ҋ@J
 * @author	ariizumi
 * @data	11/06/27
 */
//======================================================================
#include <gflib.h>

#include "btlv_wait_camera.h"

namespace btl
{

WaitCameraSys::WaitCameraSys(BattleViewSystem *core)
:mBtlvCore(core)
,mState(STATE_WAIT)
,mMovePattern(STATE_S_A1)
{
  
}

void WaitCameraSys::Update(void)
{
  switch( mState )
  {
  case STATE_WAIT: //񓮍
    break;
  case STATE_IDLE: //ҋ@
    {
      gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();

      static const u32 frame = 150;
      gfl::math::VEC3 camPos,camTrg;
      gfl::math::VEC3 trgPos,trgTrg;
      mBtlvCore->GetCameraPosTarget( &camPos , &camTrg );
      //ԃ`FbN
      switch( mMovePattern )
      {
      case STATE_S_A1:
        trgPos.Set( 30.0f,75.0f,350.0f );
        trgTrg.Set( 140.0f,40.0f,-60.0f );
        mMovePattern = STATE_A1_A2;
        break;
      case STATE_A1_A2:
        trgPos.Set( 73.0f,128.0f,351.0f );
        trgTrg.Set( 85.0f,-54.0f,-40.0f );
        mMovePattern = STATE_A2_S;
        break;
      case STATE_A2_S:
        mBtlvCore->GetDefaultCamera(&trgPos,&trgTrg );
        mMovePattern = STATE_S_A1;
        break;
      }
      mTransCamPos.Restart( camPos , trgPos , frame , heapMem );
      mTransCamTrg.Restart( camTrg , trgTrg , frame , heapMem );
      mState = STATE_MOVE;
    }
    
  
    break;
  case STATE_MOVE: //ړ
    {
      gfl::math::VEC3 camPos,camTrg;

      camPos = mTransCamPos.Update();
      camTrg = mTransCamTrg.Update();
      mBtlvCore->SetCameraPosTarget( camPos , camTrg );
      if( mTransCamPos.IsEnd() && mTransCamTrg.IsEnd() )
      {
        mState = STATE_IDLE;
      }
    }
    break;
  case STATE_GO_END: //Iڍs
    gfl::math::VEC3 camPos,camTrg;

    camPos = mTransCamPos.Update();
    camTrg = mTransCamTrg.Update();
    mBtlvCore->SetCameraPosTarget( camPos , camTrg );
    if( mTransCamPos.IsEnd() && mTransCamTrg.IsEnd() )
    {
      mState = STATE_WAIT;
    }
    break;
  }
}

void WaitCameraSys::StartCamera(void)
{
  mState = STATE_IDLE;
}

void WaitCameraSys::EndCamera(void)
{
  if( mState != STATE_WAIT )
  {
    gfl::heap::HeapBase *heapMem = mBtlvCore->GetHeapMem();
    gfl::math::VEC3 camPos,camTrg;
    gfl::math::VEC3 trgPos,trgTrg;
    mBtlvCore->GetDefaultCamera(&trgPos,&trgTrg );
    mBtlvCore->GetCameraPosTarget( &camPos , &camTrg );

    mTransCamPos.Restart( camPos , trgPos , 10 , heapMem );
    mTransCamTrg.Restart( camTrg , trgTrg , 10 , heapMem );

    mState = STATE_GO_END;
  }
}

bool WaitCameraSys::WaitEnd(void)
{
  if( mState == STATE_WAIT )
  {
    return true;
  }
  return false;
}


}//namespace btl
