//=================================================================================================
/**
 * @file SoundLevelManager.h
 * @brief TEhKwǗNX
 * @author obata_toshihiro
 * @date 2011.06.27
 */
//=================================================================================================
#ifndef __SOUNDLEVELMANAGER_H__
#define __SOUNDLEVELMANAGER_H__
#include <gflib.h>


namespace snd {


  class SoundLevelManager
  {
    GFL_FORBID_COPY_AND_ASSIGN( SoundLevelManager );


    public:
    
    struct Settings {
      u32 min_sound_handle_index;  // gpTEhnh̍ŏCfbNX
      u32 max_sound_handle_index;  // gpTEhnh̍őCfbNX
    };
    SoundLevelManager( gfl::heap::HeapBase* heap, 
        gfl::snd::SoundSystem* sound_system, const Settings& settings );
    ~SoundLevelManager();

    // KwԎ擾
    u32 GetSoundItemId( void );
    u32	GetSoundHandleIndex( void );

    // TEh
    bool LoadSoundData( u32 sound_item_id );
    void UnloadSoundData( void );
    bool PushSoundData( void );
    bool PopSoundData( void );



    private:

    // Kw̏
    struct LevelState {
      bool valid_flag;                   // Lȃf[^ǂ
      u32 sound_item_id;                 // TEhACeID
      u32 sound_handle_index;            // TEhnh̃CfbNX
      s32 sound_heap_level_before_load;  // TEhf[^[hÕq[vx
      s32 sound_heap_level_after_load;   // TEhf[^[h̃q[vx
    }; 

    gfl::snd::SoundSystem* m_sound_system;
    u32 m_min_sound_handle_index;
    LevelState* m_level_stack;
    u32 m_max_level;
    u32 m_current_level;

    void InitLevelState( u32 level, s32 initial_heap_level );
    LevelState* GetCurrentLevelState( void );
    LevelState* GetLevelState( u32 level );
  };



} // namespace snd


#endif // __SOUNDLEVELMANAGER_H__
