// Copyright Epic Games, Inc. All Rights Reserved.

#include "StaticMeshAttributes.h"

namespace MeshAttribute
{
	const FName VertexInstance::TextureCoordinate("TextureCoordinate");
	const FName VertexInstance::Normal("Normal");
	const FName VertexInstance::Tangent("Tangent");
	const FName VertexInstance::BinormalSign("BinormalSign");
	const FName VertexInstance::Color("Color");

	const FName Edge::IsHard("IsHard");

	const FName Polygon::Normal("Normal");
	const FName Polygon::Tangent("Tangent");
	const FName Polygon::Binormal("Binormal");
	const FName Polygon::Center("Center");

	const FName PolygonGroup::ImportedMaterialSlotName("ImportedMaterialSlotName");

PRAGMA_DISABLE_DEPRECATION_WARNINGS
	// all deprected in 4.26
	const FName Vertex::CornerSharpness("CornerSharpness");
	const FName PolygonGroup::CastShadow("CastShadow");
	const FName Edge::CreaseSharpness("CreaseSharpness");
	const FName Edge::IsUVSeam("IsUVSeam");
	const FName PolygonGroup::EnableCollision("EnableCollision");
PRAGMA_ENABLE_DEPRECATION_WARNINGS
}



void FStaticMeshAttributes::Register()
{
	// Add basic vertex attributes
	MeshDescription.VertexAttributes().RegisterAttribute<float>(MeshAttribute::Vertex::CornerSharpness, 1, 0.0f, EMeshAttributeFlags::Lerpable);

	// Add basic vertex instance attributes
	MeshDescription.VertexInstanceAttributes().RegisterAttribute<FVector2D>(MeshAttribute::VertexInstance::TextureCoordinate, 1, FVector2D::ZeroVector, EMeshAttributeFlags::Lerpable);
	MeshDescription.VertexInstanceAttributes().RegisterAttribute<FVector>(MeshAttribute::VertexInstance::Normal, 1, FVector::ZeroVector, EMeshAttributeFlags::AutoGenerated);
	MeshDescription.VertexInstanceAttributes().RegisterAttribute<FVector>(MeshAttribute::VertexInstance::Tangent, 1, FVector::ZeroVector, EMeshAttributeFlags::AutoGenerated);
	MeshDescription.VertexInstanceAttributes().RegisterAttribute<float>(MeshAttribute::VertexInstance::BinormalSign, 1, 0.0f, EMeshAttributeFlags::AutoGenerated);
	MeshDescription.VertexInstanceAttributes().RegisterAttribute<FVector4>(MeshAttribute::VertexInstance::Color, 1, FVector4(1.0f, 1.0f, 1.0f, 1.0f), EMeshAttributeFlags::Lerpable);

	// Add basic edge attributes
	MeshDescription.EdgeAttributes().RegisterAttribute<bool>(MeshAttribute::Edge::IsHard, 1, false);
	MeshDescription.EdgeAttributes().RegisterAttribute<float>(MeshAttribute::Edge::CreaseSharpness, 1, 0.0f, EMeshAttributeFlags::Lerpable);

	// Add basic polygon attributes

	// Add basic polygon group attributes
	MeshDescription.PolygonGroupAttributes().RegisterAttribute<FName>(MeshAttribute::PolygonGroup::ImportedMaterialSlotName); //The unique key to match the mesh material slot

	// Call super class
	FMeshAttributes::Register();
}


void FStaticMeshAttributes::RegisterPolygonNormalAndTangentAttributes()
{
	MeshDescription.PolygonAttributes().RegisterAttribute<FVector>(MeshAttribute::Polygon::Normal, 1, FVector::ZeroVector, EMeshAttributeFlags::Transient);
	MeshDescription.PolygonAttributes().RegisterAttribute<FVector>(MeshAttribute::Polygon::Tangent, 1, FVector::ZeroVector, EMeshAttributeFlags::Transient);
	MeshDescription.PolygonAttributes().RegisterAttribute<FVector>(MeshAttribute::Polygon::Binormal, 1, FVector::ZeroVector, EMeshAttributeFlags::Transient);
	MeshDescription.PolygonAttributes().RegisterAttribute<FVector>(MeshAttribute::Polygon::Center, 1, FVector::ZeroVector, EMeshAttributeFlags::Transient);
}
