// Copyright Epic Games, Inc. All Rights Reserved.

#include "BaseBehaviors/MouseHoverBehavior.h"


UMouseHoverBehavior::UMouseHoverBehavior()
{
	Target = nullptr;
}

EInputDevices UMouseHoverBehavior::GetSupportedDevices()
{
	return EInputDevices::Mouse;
}

void UMouseHoverBehavior::Initialize(IHoverBehaviorTarget* TargetIn)
{
	this->Target = TargetIn;
}

bool UMouseHoverBehavior::WantsHoverEvents()
{
	return true;
}


FInputCaptureRequest UMouseHoverBehavior::WantsHoverCapture(const FInputDeviceState& InputState)
{
	if (Target != nullptr)
	{
		Modifiers.UpdateModifiers(InputState, Target);

		FInputRayHit Hit = Target->BeginHoverSequenceHitTest(InputState.Mouse.WorldRay);
		if (Hit.bHit)
		{
			return FInputCaptureRequest::Begin(this, EInputCaptureSide::Any, Hit.HitDepth);
		}
	}
	return FInputCaptureRequest::Ignore();
}

FInputCaptureUpdate UMouseHoverBehavior::BeginHoverCapture(const FInputDeviceState& InputState, EInputCaptureSide eSide)
{
	check(Target != nullptr);
	Modifiers.UpdateModifiers(InputState, Target);
	Target->OnBeginHover(InputState.Mouse.WorldRay);
	return FInputCaptureUpdate::Begin(this, eSide);
}

FInputCaptureUpdate UMouseHoverBehavior::UpdateHoverCapture(const FInputDeviceState& InputState)
{
	check(Target != nullptr);
	Modifiers.UpdateModifiers(InputState, Target);
	if (Target->OnUpdateHover(InputState.Mouse.WorldRay))
	{
		return FInputCaptureUpdate::Continue();
	}
	return FInputCaptureUpdate::End();
}

void UMouseHoverBehavior::EndHoverCapture()
{
	check(Target != nullptr);
	Target->OnEndHover();
}



