// Copyright Epic Games, Inc. All Rights Reserved.

#include "Engine/LevelScriptBlueprint.h"
#include "Misc/PackageName.h"
#include "Engine/LevelScriptActor.h"
#include "UObject/Package.h"

//////////////////////////////////////////////////////////////////////////
// ULevelScriptBlueprint

ULevelScriptBlueprint::ULevelScriptBlueprint(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
}

#if WITH_EDITOR

FString ULevelScriptBlueprint::GetFriendlyName() const
{
#if WITH_EDITORONLY_DATA
	return FriendlyName;
#endif
	return UBlueprint::GetFriendlyName();
}

FString ULevelScriptBlueprint::CreateLevelScriptNameFromLevel(const ULevel* Level)
{
	// Since all maps are named "PersistentLevel" the level script name is based on the LevelPackage
	check(Level);
	UObject* LevelPackage = Level->GetOutermost();
	return FPackageName::GetShortName(LevelPackage->GetFName().GetPlainNameString());

}

#endif	//#if WITH_EDITOR

