// Copyright Epic Games, Inc. All Rights Reserved.

using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace Tools.DotNETCommon.Perforce
{
	/// <summary>
	/// Describes the action performed by the user when resolving the integration
	/// </summary>
	public enum IntegrateAction
	{
		/// <summary>
		/// file did not previously exist; it was created as a copy of partner-file
		/// </summary>
		[PerforceEnum("branch from")]
		BranchFrom,

		/// <summary>
		/// partner-file did not previously exist; it was created as a copy of file.
		/// </summary>
		[PerforceEnum("branch into")]
		BranchInto,

		/// <summary>
		/// file was integrated from partner-file, accepting merge.
		/// </summary>
		[PerforceEnum("merge from")]
		MergeFrom,

		/// <summary>
		/// file was integrated into partner-file, accepting merge.
		/// </summary>
		[PerforceEnum("merge into")]
		MergeInto,

		/// <summary>
		/// file was integrated from partner-file, accepting theirs and deleting the original.
		/// </summary>
		[PerforceEnum("moved from")]
		MovedFrom,

		/// <summary>
		/// file was integrated into partner-file, accepting theirs and creating partner-file if it did not previously exist.
		/// </summary>
		[PerforceEnum("moved into")]
		MovedInto,

		/// <summary>
		/// file was integrated from partner-file, accepting theirs.
		/// </summary>
		[PerforceEnum("copy from")]
		CopyFrom,

		/// <summary>
		/// file was integrated into partner-file, accepting theirs.
		/// </summary>
		[PerforceEnum("copy into")]
		CopyInto,

		/// <summary>
		/// file was integrated from partner-file, accepting yours.
		/// </summary>
		[PerforceEnum("ignored")]
		Ignored,

		/// <summary>
		/// file was integrated into partner-file, accepting yours.
		/// </summary>
		[PerforceEnum("ignored by")]
		IgnoredBy,

		/// <summary>
		/// file was integrated from partner-file, and partner-file had been previously deleted.
		/// </summary>
		[PerforceEnum("delete from")]
		DeleteFrom,

		/// <summary>
		/// file was integrated into partner-file, and file had been previously deleted.
		/// </summary>
		[PerforceEnum("delete into")]
		DeleteInto,

		/// <summary>
		/// file was integrated from partner-file, and file was edited within the p4 resolve process.
		/// </summary>
		[PerforceEnum("edit from")]
		EditFrom,

		/// <summary>
		/// file was integrated into partner-file, and partner-file was reopened for edit before submission.
		/// </summary>
		[PerforceEnum("edit into")]
		EditInto,

		/// <summary>
		/// file was integrated from a deleted partner-file, and partner-file was reopened for add (that is, someone restored a deleted file by syncing back to a pre-deleted revision and adding the file).
		/// </summary>
		[PerforceEnum("add from")]
		AddFrom,

		/// <summary>
		/// file was integrated into previously nonexistent partner-file, and partner-file was reopened for add before submission.
		/// </summary>
		[PerforceEnum("add into")]
		AddInto,
	}
}
