// Copyright Epic Games, Inc. All Rights Reserved.

#include "FoliageTypeFactory.h"
#include "AssetTypeCategories.h"
#include "FoliageType_InstancedStaticMesh.h"
#include "FoliageType_Actor.h"

#define LOCTEXT_NAMESPACE "FoliageTypeFactory"

UFoliageType_InstancedStaticMeshFactory::UFoliageType_InstancedStaticMeshFactory(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
	bCreateNew = true;
	bEditAfterNew = true;
	SupportedClass = UFoliageType_InstancedStaticMesh::StaticClass();
}

UObject* UFoliageType_InstancedStaticMeshFactory::FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn)
{
	return NewObject<UFoliageType_InstancedStaticMesh>(InParent, Class, Name, Flags | RF_Transactional);
}

FText UFoliageType_InstancedStaticMeshFactory::GetToolTip() const
{
	return LOCTEXT("FoliageTypeStaticMeshToolTip", "Static Mesh Foliage is a foliage type that will use mesh instancing and is optimal for non-interactive foliage.");
}

UFoliageType_ActorFactory::UFoliageType_ActorFactory(const FObjectInitializer& ObjectInitializer)
	: Super(ObjectInitializer)
{
	bCreateNew = true;
	bEditAfterNew = true;
	SupportedClass = UFoliageType_Actor::StaticClass();
}

UObject* UFoliageType_ActorFactory::FactoryCreateNew(UClass* Class, UObject* InParent, FName Name, EObjectFlags Flags, UObject* Context, FFeedbackContext* Warn)
{
	return NewObject<UFoliageType_Actor>(InParent, Class, Name, Flags | RF_Transactional);
}

FText UFoliageType_ActorFactory::GetToolTip() const
{
	return LOCTEXT("FoliageTypeActorToolTip", "Actor Foliage is a foliage type that will place blueprint/native actor instances. The cost of painting this foliage is the same as adding actors in a scene.");
}

#undef LOCTEXT_NAMESPACE
