// Copyright Epic Games, Inc. All Rights Reserved.

using UnrealBuildTool;

public class LuminTargetPlatform : ModuleRules
{
	public LuminTargetPlatform(ReadOnlyTargetRules Target) : base(Target)
	{
		BinariesSubFolder = "Lumin";

		PrivateDependencyModuleNames.AddRange(
			new string[]
			{
				"Core",
				"CoreUObject",
				"TargetPlatform",
				"DesktopPlatform",
				"AndroidTargetPlatform",
				"AndroidDeviceDetection",
			}
		);

		PublicIncludePaths.AddRange(
			new string[]
			{
				"Runtime/Core/Public/Lumin"
			}
		);

		if (Target.bCompileAgainstEngine)
		{
			PrivateDependencyModuleNames.Add("Engine");
		}

		PrivateIncludePaths.AddRange(
		new string[] {
			"Developer/Android/AndroidTargetPlatform/Private"
		}
	);
	}
}