using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using System.Threading.Tasks;
using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Diagnostics;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Microsoft.Extensions.Logging;
using WebApplication2.Filter;
using WebApplication2.Middleware;
//using Newtonsoft.Json;

namespace WebApplication2
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        // This method gets called by the runtime. Use this method to add services to the container.
        public void ConfigureServices(IServiceCollection services)
        {
            services.AddControllers();
            #region עȫ쳣
            //services.AddControllers(options =>
            //{
            //    options.Filters.Add(new CustomerExceptionFilter());
            //});
            #endregion
            services.AddMvc().AddNewtonsoftJson(options =>
            {
                // ѭ
                options.SerializerSettings.ReferenceLoopHandling = ReferenceLoopHandling.Ignore;
                // ʹշ
                options.SerializerSettings.ContractResolver = new DefaultContractResolver();
                // ʱʽ
                options.SerializerSettings.DateFormatString = "yyyy-MM-dd HH:mm:ss";
                // ֶΪnullֵֶβ᷵صǰ
                // options.SerializerSettings.NullValueHandling = NullValueHandling.Ignore;
            });
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                //app.UseExceptionHandler(builder => builder.Use(ExceptionHandlerDemo));
            }


            app.UseExceptionMiddleware();

            app.UseRouting();

            app.UseAuthorization();

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }

        //private async Task ExceptionHandlerDemo(HttpContext httpContext, Func<Task> next)
        //{
        //    //ϢExceptionHandlerMiddlewareмṩExceptionHandlerMiddlewareм񵽵쳣Ϣ
        //    var exceptionDetails = httpContext.Features.Get<IExceptionHandlerFeature>();
        //    var ex = exceptionDetails?.Error;

        //    if (ex != null)
        //    {
        //        httpContext.Response.ContentType = "application/problem+json";

        //        var title = "An error occured: " + ex.Message;
        //        var details = ex.ToString();

        //        var problem = new ProblemDetails
        //        {
        //            Status = 500,
        //            Title = title,
        //            Detail = details
        //        };

        //        var stream = httpContext.Response.Body;
        //        await JsonSerializer.SerializeAsync(stream, problem);
        //    }
        //}
    }
}
