﻿using Microsoft.AspNetCore.Http;
using Microsoft.AspNetCore.Mvc;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text.Json;
using Newtonsoft.Json;
using System.Threading.Tasks;
using WebApplication2.Filter;
using WebApplication2.Model;

namespace WebApplication2.Middleware
{
    public class CustomerExceptionMiddleware
    {
        /// <summary>
        /// 委托
        /// </summary>
        private readonly RequestDelegate _next;

        public CustomerExceptionMiddleware(RequestDelegate next)
        {
            _next = next;
        }

        public async Task Invoke(HttpContext context)
        {
            try
            {
                await _next(context);
            }
            catch (CustomerException messgae)
            {
                context.Response.ContentType = "application/json;charset=utf-8";
                var problem = new ResultModel<string>()
                {
                    ResultCode = 1,
                    ResultMsg = "Success",
                    ResultData = messgae.Message
                };
                var stream = context.Response.Body;
                await System.Text.Json.JsonSerializer.SerializeAsync(stream, problem);
            }
            catch (Exception ex)
            {

                context.Response.ContentType = "application/problem+json";

                var title = "An error occured: " + ex.Message;
                var details = ex.ToString();


                var problem = new ProblemDetails
                {
                    Status = 200,
                    Title = title,
                    Detail = details
                };

                var stream = context.Response.Body;
                await System.Text.Json.JsonSerializer.SerializeAsync(stream, problem);
            }

        }
    }
}
