﻿using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.Hosting;
using Furion;
using FastFurionApi.Core;

namespace FastFurionApi.Web.Core
{
    [AppStartup(10)]
    public class MyStartup : AppStartup
    {
        public void ConfigureServices(IServiceCollection services)
        {
            // 项目配置选项
            services.AddProjectOptions();
            // 缓存注册
            services.AddCache();
            // SqlSugar
            services.AddSqlSugarScope();
            // JWT
            services.AddJwt<JwtHandler>();
            // 允许跨域
            services.AddCorsAccessor();
            // 控制台格式化
            services.AddConsoleFormatter(options =>
            {
                options.DateFormat = "yyyy-MM-dd HH:mm:ss(zzz) dddd";
            });
            services.AddControllers()
                    .AddInjectWithUnifyResult();
        }

        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }

            // 强制https
            //app.UseHttpsRedirection();

            app.UseRouting();

            app.UseCorsAccessor();

            app.UseAuthentication();
            app.UseAuthorization();

            app.UseInject(string.Empty);

            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllers();
            });
        }
    }
}