﻿using FastFurionApi.Core;
using Furion;
using Microsoft.Extensions.DependencyInjection;

namespace FastFurionApi.Web.Core;
/// <summary>
/// 项目配置项
/// </summary>
public static class ProjectOptions
{
    /// <summary>
    /// 注册项目配置选项
    /// </summary>
    /// <param name="services"></param>
    /// <returns></returns>
    public static IServiceCollection AddProjectOptions(this IServiceCollection services)
    {
        services.AddConfigurableOptions<DbConnectionOptions>();
        services.AddConfigurableOptions<SnowIdOptions>();
        services.AddConfigurableOptions<CacheOptions>();
        return services;
    }
}
