﻿using Furion.DependencyInjection;
using System.Collections.Generic;
using System.Threading.Tasks;

namespace FastFurionApi.Core.Service;

public interface ISysCacheService : ISingleton
{
    /// <summary>
    /// 获取所有缓存键名
    /// </summary>
    /// <returns></returns>
    List<string> GetAllCacheKeys();

    /// <summary>
    /// 获取缓存-根据指定的键名获取缓存
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <param name="key"></param>
    /// <returns></returns>
    T Get<T>(string key);

    /// <summary>
    /// 获取缓存-根据指定的键名获取缓存
    /// </summary>
    /// <typeparam name="T"></typeparam>
    /// <param name="key"></param>
    /// <returns></returns>
    Task<T> GetAsync<T>(string key);

}
