﻿using SqlSugar;

namespace FastFurionApi.Core.Entity;

/// <summary>
/// 系统租户表
/// </summary>
[SugarTable(TableDescription = "系统租户表")]
[SysTable]
public class SysTenant : EntityBase
{
    /// <summary>
    /// 用户Id
    /// </summary>
    [SugarColumn(ColumnDescription = "用户Id")]
    public long UserId { get; set; }

    /// <summary>
    /// 机构Id
    /// </summary>
    [SugarColumn(ColumnDescription = "机构Id")]
    public long OrgId { get; set; }

    /// <summary>
    /// 主机地址
    /// </summary>
    [SugarColumn(ColumnDescription = "主机地址", Length = 128)]
    public string? Host { get; set; }

    /// <summary>
    /// 租户类型枚举值
    /// </summary>
    [SugarColumn(ColumnDescription = "租户类型枚举值")]
    public TenantTypeEnum TenantType { get; set; }

    /// <summary>
    /// 数据库类型枚举值
    /// </summary>
    [SugarColumn(ColumnDescription = "数据库类型枚举值")]
    public SqlSugar.DbType DbType { get; set; }

    /// <summary>
    /// 数据库连接字符串
    /// </summary>
    [SugarColumn(ColumnDescription = "数据库连接字符串", Length = 255)]
    public string? Connection { get; set; }

    /// <summary>
    /// 数据库标识
    /// </summary>
    [SugarColumn(ColumnDescription = "数据库标识", Length = 128)]
    public string? ConfigId { get; set; }

    /// <summary>
    /// 状态枚举值
    /// </summary>
    [SugarColumn(ColumnDescription = "状态枚举值")]
    public StatusEnum Status { get; set; } = StatusEnum.Enable;

    /// <summary>
    /// 排序
    /// </summary>
    [SugarColumn(ColumnDescription = "排序")]
    public int OrderNo { get; set; } = 100;

    /// <summary>
    /// 备注
    /// </summary>
    [SugarColumn(ColumnDescription = "备注", Length = 255)]
    public string? Remark { get; set; }
}