﻿using Furion.ConfigurableOptions;
using NewLife.Caching;

namespace FastFurionApi.Core;

/// <summary>
/// 缓存配置选项
/// </summary>
public class CacheOptions : IConfigurableOptions
{
    /// <summary>
    /// 缓存前缀
    /// </summary>
    public string Prefix { get; set; }

    /// <summary>
    /// 缓存类型
    /// </summary>
    public string CacheType { get; set; }

    /// <summary>
    /// Redis缓存
    /// </summary>
    public RedisOption Redis { get; set; }
}

/// <summary>
/// Redis缓存
/// </summary>
public sealed class RedisOption : RedisOptions
{
}