﻿using Furion;
using Microsoft.Extensions.DependencyInjection;
using NewLife.Caching;

namespace FastFurionApi.Core;

/// <summary>
/// 缓存启动
/// </summary>
public static class CacheSetup
{
    /// <summary>
    /// 缓存注册(新生命Redis组件)
    /// </summary>
    /// <param name="services"></param>
    public static void AddCache(this IServiceCollection services)
    {
        ICache cache = Cache.Default;

        var cacheOptions = App.GetOptions<CacheOptions>();
        if (cacheOptions.CacheType == CacheTypeEnum.Redis.ToString())
        {
            //var fullRedis = new FullRedis();
            //fullRedis.Init(cacheOptions.RedisConnectionString);
            //cache = fullRedis;

            cache = new FullRedis(new RedisOptions
            {
                Configuration = cacheOptions.Redis.Configuration,
                Prefix = cacheOptions.Redis.Prefix,
            });
        }

        services.AddSingleton(cache);
    }
}