﻿using FastFurionApi.Core;
using FastFurionApi.Core.Entity;

namespace FastFurionApi.Application
{
    /// <summary>
    /// 系统服务接口
    /// </summary>
    public class SystemAppService : IDynamicApiController
    {
        private readonly SqlSugarRepository<SysOrg> _sysOrgRep;
        private readonly ISystemService _systemService;
        public SystemAppService(SqlSugarRepository<SysOrg> sysOrgRep, ISystemService systemService)
        {
            _sysOrgRep = sysOrgRep;
            _systemService = systemService;
        }

        /// <summary>
        /// 获取系统描述
        /// </summary>
        /// <returns></returns>
        public string GetDescription()
        {
            return _systemService.GetDescription();
        }

        public string GetUser()
        {
            var iSugarQueryable = _sysOrgRep.AsQueryable().OrderBy(u => u.OrderNo).ToList();
            return _systemService.GetDescription();
        }
    }
}