﻿using SqlSugar;
using System;
using System.Collections.Generic;
using System.Linq;
using System.Security.Principal;
using System.Text;
using System.Threading.Tasks;

namespace ConsoleSqlSugar
{
    [SugarTable("Students", "学生表")]
    public class Student
    {
        [SugarColumn(IsPrimaryKey = true, IsIdentity = true)]//数据库是自增才配自增 
        public int Id { get; set; }
        public int? SchoolId { get; set; }

        [SugarColumn(ColumnDescription = "学生姓名", ColumnName = "StudentName", IsNullable = true, Length = 100)]//数据库与实体不一样设置列名 
        public string Name { get; set; }

        public string? Hobby { get; set; }

        public string StudentNum { get; set; }

        [SugarColumn(OldColumnName = "Birthday")]
        public DateTime StudentDate { get; set; } = DateTime.Now;

        [SugarColumn(ColumnDescription = "性别", IsNullable = true)]
        public int Sex { get; set; }

        [SugarColumn(IsIgnore = true)]
        public string SexName { get { return Sex == 0 ? "男" : "女"; } }

        [SugarColumn(ColumnDescription = "邮箱", IsNullable = true)]
        public string Email { get; set; }
    }
}
