﻿using FakeXieCheng.API.Models;
using System;
using System.Collections.Generic;

namespace FakeXieCheng.API.Services
{
    /// <summary>
    ///  如何将数据传入到模型中呢？这就用到了数据仓库Repository。旅游路线数据仓库接口属于服务级别的组件。
    /// </summary>
    public interface ITouristRouteRepository
    {
        /// <summary>
        /// 获取旅游路线列表
        /// </summary>
        /// <returns></returns>
        IEnumerable<TouristRoute> GetTouristRoutes();

        /// <summary>
        /// 根据旅游路线Id获取特定的旅游路线
        /// </summary>
        /// <param name="toursitRouteId">旅游路线Id</param>
        /// <returns></returns>
        TouristRoute GetTouristRouteById(Guid toursitRouteId);


    }
}
