﻿using System;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace FakeXieCheng.API.Models
{
    /// <summary>
    /// 旅游路线照片数据模型
    /// </summary>
    public class TouristRoutePicture
    {
        /// <summary>
        /// 主键Id
        /// </summary>
        [Key] //主键Id,使用的是整数,这个Id是由数据库 自动产生 自动管理的，编号数字是数据库自动累加，需要用到数据库，所以就要引用using System.ComponentModel.DataAnnotations.Schema;
        [DatabaseGenerated(DatabaseGeneratedOption.Identity)]//数据库的自增类型
        public int Id { get; set; }
        /// <summary>
        /// 旅游路线照片路径
        /// </summary>
        [MaxLength(100)] //MaxLength 表示长度限制不能超过100
        public string Url { get; set; }
        /// <summary>
        /// 旅游路线的外键关系
        /// </summary>
        [ForeignKey("TouristRouteId")]//图片模型与路线模型的外键联系。这个TouristRouteId 来源是因为Entity Framework 在映射数据库的时候会自动把每个模型的主键 以类名+主键Id 的形式作为外键关联,也就是TouristRoute+Id=TouristRouteId,从而被进行外键联系
        public Guid TouristRouteId { get; set; }
        /// <summary>
        /// 建立外键关系-连接属性 
        /// </summary>
        public TouristRoute TouristRoute { get; set; }
    }
}
