﻿using FakeXieCheng.API.Enum;
using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.ComponentModel.DataAnnotations.Schema;

namespace FakeXieCheng.API.Models
{
    /// <summary>
    /// 旅游路线数据模型（验证数据模型：添加数据库限制，主键信息，以及外键联系信息等等。引入System.ComponentModel.DataAnnotations）
    /// </summary>
    public class TouristRoute
    {
        #region 基础属性
        /// <summary>
        /// 旅游路线Id
        /// </summary>
        [Key] //主键Id
        public Guid Id { get; set; }
        /// <summary>
        /// 旅游路线名称
        /// </summary>
        [Required, MaxLength(100)]//Required 表示不能为空   MaxLength 表示长度限制不能超过100
        public string Title { get; set; }
        /// <summary>
        /// 旅游路线描述、简介
        /// </summary>
        [Required, MaxLength(1500)]//Required 表示不能为空   MaxLength 表示长度限制不能超过1500
        public string Description { get; set; }
        /// <summary>
        /// 原始价格
        /// </summary>
        [Column(TypeName = "Decimal(18,2)")]//存到数据库中要保留2位小数，作为数据库表的一列Column。需要用到数据库的就需要引用 System.ComponentModel.DataAnnotations.Schema   (Component[kəmˈpəʊnənt] 组成的、构成的 Annotations[ˌænəʊˈteɪʃ(ə)nz] 注解 注释)
        public decimal OriginalPrice { get; set; }
        /// <summary>
        /// 折扣百分比
        /// </summary>
        [Range(0.0, 1.0)] //0-1之间的小数 范围限制 
        public double? DiscountPercent { get; set; }
        /// <summary>
        /// 创建时间
        /// </summary>
        public DateTime CreatedTime { get; set; }
        /// <summary>
        /// 更新时间
        /// </summary>
        public DateTime? UpdateTime { get; set; }
        /// <summary>
        /// 出发时间
        /// </summary>
        public DateTime? DepartureTime { get; set; }
        /// <summary>
        ///  旅游路线的特色、卖点介绍
        /// </summary>
        [MaxLength] // MaxLength 不填写数字 表示没有最大限制 及使用最大数量长度
        public string Features { get; set; }
        /// <summary>
        /// 线路的费用说明
        /// </summary>
        [MaxLength] // MaxLength 不填写数字 表示没有最大限制 及使用最大数量长度
        public string Fees { get; set; }
        /// <summary>
        ///  备注说明
        /// </summary>
        [MaxLength] // MaxLength 不填写数字 表示没有最大限制 及使用最大数量长度
        public string Notes { get; set; }
        /// <summary>
        /// 评分
        /// </summary>
        public double? Rating { get; set; }
        /// <summary>
        /// 旅游天数
        /// </summary>
        public TravelDays? TravelDays { get; set; }
        /// <summary>
        /// 旅游类型
        /// </summary>
        public TripType? TripType { get; set; }
        /// <summary>
        ///  出发地
        /// </summary>
        public DepartureCity? DepartureCity { get; set;}


        #endregion

        #region 关系属性-通过外键建立
        public ICollection<TouristRoutePicture> TouristRoutePictures { get; set; } = new List<TouristRoutePicture>();
        #endregion

    }
}
