﻿using FakeXieCheng.API.DataBase;
using FakeXieCheng.API.Models;
using FakeXieCheng.API.Services;
using Microsoft.EntityFrameworkCore;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FakeXieCheng.API.Implementation
{
    public class TouristRouteRepository : ITouristRouteRepository
    {
        /// <summary>
        /// 数据仓库需要使用数据库连接器 AppDbContext 来链接数据库 
        /// </summary>
        private readonly AppDbContext _context;
        public TouristRouteRepository(AppDbContext appDbContext)
        {
            _context = appDbContext;
        }

        public TouristRoute GetTouristRouteById(Guid toursitRouteId)
        {
            return _context.TouristRoutes.FirstOrDefault(n => n.Id == toursitRouteId);
            //return _context.TouristRoutes.Include(t => t.TouristRoutePictures).Where(w => w.Id == toursitRouteId).FirstOrDefault();
        }

        public IEnumerable<TouristRoute> GetTouristRoutes()
        {
            return _context.TouristRoutes;
        }
    }
}
