﻿using FakeXieCheng.API.Models;
using FakeXieCheng.API.Services;
using System;
using System.Collections.Generic;
using System.Linq;

namespace FakeXieCheng.API.Implementation
{
    /// <summary>
    /// 如何将数据传入到模型中呢？这就用到了数据仓库Repository类，实现ITouristRouteRepository接口
    /// 这是一个服务组件，在项目的不同位置都有可能会使用到，在使用之前首先要把它注册到系统的依赖注入容器中
    /// </summary>
    public class MockTouristRouteRepository : ITouristRouteRepository
    {
        /// <summary>
        /// 私有旅游路线列表字段
        /// </summary>
        private List<TouristRoute> _touristRoutes;

        public MockTouristRouteRepository()
        {
            if (_touristRoutes == null)
                InitializeTouristRoutes();
        }
        public void InitializeTouristRoutes()
        {
            _touristRoutes = new List<TouristRoute>()
            {
                new TouristRoute{
                    Id=Guid.NewGuid(),
                    Title="黄山旅游路线",
                    Description="黄山是一个美丽的地方",
                    OriginalPrice=1200,
                    Features="<p>吃住行游购娱</p>",
                    Fees="<p>交通费用自理</p>",
                    Notes="<p>小心危险！</p>",
                },
                new TouristRoute{
                    Id=Guid.NewGuid(),
                    Title="华山旅游路线",
                    Description="华山第一山",
                    OriginalPrice=1500,
                    Features="<p>吃住行游购娱</p>",
                    Fees="<p>交通费用自理</p>",
                    Notes="<p>小心危险！</p>",
                },
            };
        }

        public IEnumerable<TouristRoute> GetTouristRoutes()
        {
            return _touristRoutes;
        }

        public TouristRoute GetTouristRouteById(Guid toursitRouteId)
        {
            //linq 将声明式编程转换化为命令式编程的语法糖 
            return _touristRoutes.FirstOrDefault(t => t.Id == toursitRouteId);
        }

    }
}
