// Karma configuration
// Generated on Thu Jul 07 2022 16:52:42 GMT-0400 (Eastern Daylight Time)

module.exports = function(config) {
  config.set({

    // base path that will be used to resolve all patterns (eg. files, exclude)
    basePath: './',

    proxies: {
      "/js/": "/base/js/",
      "/test/": "/base/test/"
    },


    // frameworks to use
    // available frameworks: https://npmjs.org/browse/keyword/karma-adapter
    frameworks: ['jasmine'],


    // list of files / patterns to load in the browser
    files: [
      { pattern: "test/**/*.tests.js", type: "module" },

      { pattern: "test/*.tests.js", type: "module" },
      { pattern: "test/mocks/*.js", type: "module", included: false },
      { pattern: "js/**/*.js", type: "module", included: false },
      { pattern: "js/*.js", type: "module", included: false }

    ],


    // list of files / patterns to exclude
    exclude: [
    ],


    // preprocess matching files before serving them to the browser
    // available preprocessors: https://npmjs.org/browse/keyword/karma-preprocessor
    preprocessors: {
      'js/mjs/**/*.js': 'coverage'
    },

    coverageReporter: {
      type : 'html',
      dir : 'coverage/',
      subdir: '.',
      instrumenterOptions: {
          istanbul: {
              esModules: true
          }
      }
  },

    // test results reporter to use
    // possible values: 'dots', 'progress'
    // available reporters: https://npmjs.org/browse/keyword/karma-reporter
    reporters: ['progress', 'coverage'],


    // web server port
    port: 9876,


    // enable / disable colors in the output (reporters and logs)
    colors: true,


    // level of logging
    // possible values: config.LOG_DISABLE || config.LOG_ERROR || config.LOG_WARN || config.LOG_INFO || config.LOG_DEBUG
    logLevel: config.LOG_INFO,


    // enable / disable watching file and executing tests whenever any file changes
    autoWatch: true,


    // start these browsers
    // available browser launchers: https://npmjs.org/browse/keyword/karma-launcher
    browsers: ['Chrome'],


    // Continuous Integration mode
    // if true, Karma captures browsers, runs the tests and exits
    singleRun: false,

    // Concurrency level
    // how many browser should be started simultaneous
    concurrency: Infinity
  })
}
