return {
    -- The inclusion of the below line tells the language server that the first parameter of the cutscene is `WorldCutscene`.
    -- This allows it to fetch us useful documentation that shows all of the available cutscene functions while writing our cutscenes!

    ---@param cutscene WorldCutscene
    wall = function(cutscene, event)
        -- Open textbox and wait for completion
        cutscene:text("* The wall seems cracked.")

        -- If we have Susie, play a cutscene
        local susie = cutscene:getCharacter("susie")
        if susie then
            -- Detach camera and followers (since characters will be moved)
            cutscene:detachCamera()
            cutscene:detachFollowers()

            -- All text from now is spoken by Susie
            cutscene:setSpeaker(susie)
            cutscene:text("* Hey,[wait:5] think I can break\nthis wall?", "smile")

            -- Get the bottom-center of the broken wall
            local x = event.x + event.width/2
            local y = event.y + event.height/2

            -- Move Susie up to the wall over 0.75 seconds
            cutscene:walkTo(susie, x, y + 40, 0.75, "up")
            -- Move other party members behind Susie
            cutscene:walkTo(Game.world.player, x, y + 100, 0.75, "up")
            if cutscene:getCharacter("ralsei") then
                cutscene:walkTo("ralsei", x + 60, y + 100, 0.75, "up")
            end
            if cutscene:getCharacter("noelle") then
                cutscene:walkTo("noelle", x - 60, y + 100, 0.75, "up")
            end

            -- Wait 1.5 seconds
            cutscene:wait(1.5)

            -- Walk back,
            cutscene:wait(cutscene:walkTo(susie, x, y + 60, 0.5, "up", true))
            -- and run forward!
            cutscene:wait(cutscene:walkTo(susie, x, y + 20, 0.2))

            -- Slam!!
            Assets.playSound("impact")
            susie:shake(4)
            susie:setSprite("shock_up")

            -- Slide back a bit
            cutscene:slideTo(susie, x, y + 40, 0.1)
            cutscene:wait(1.5)

            -- owie
            susie:setAnimation({"away_scratch", 0.25, true})
            susie:shake(4)
            Assets.playSound("wing")

            cutscene:wait(1)
            cutscene:text("* Guess not.", "nervous")

            -- Reset Susie's sprite
            susie:resetSprite()

            -- Reattach the camera
            cutscene:attachCamera()

            -- Align the follower positions behind Kris's current position
            cutscene:alignFollowers()
            -- And reattach them, making them return to their target positions
            cutscene:attachFollowers()
            Game:setFlag("wall_hit", true)
        end
    end,

    ---@param cutscene WorldCutscene
    ---@param event Event
    ralseijoin = function(cutscene, event)
        local ralsei = cutscene:getCharacter("ralsei")
        cutscene:setSpeaker(ralsei)
        cutscene:text("* Hey.", "smile")
        cutscene:setSpeaker()
        local sel = cutscene:textChoicer("* Ask him to join?", {"YES!", "No he sucks"})
        cutscene:setSpeaker(ralsei)
        if sel == 1 then
            cutscene:text("* ...Join you? Sounds great!", "smile_b")
            cutscene:text("* I need a name, though.", "neutral")
            Game.world:transitionMusic("menu_options_uty")

            -- yanked nigh wholesale from testmod's "testing.goner_choice" cutscene
            local chosen_name
            local namer = GonerKeyboard(6, "lowercase",
                function (name)
                    chosen_name = name
                end
            )
            namer.text = "Ralsei"
            Game.stage:addChild(namer)
            cutscene:wait(function () return chosen_name ~= nil end)

            Mod:setRalseiName(chosen_name)
            Game.world.music:stop()

            cutscene:setSpeaker(ralsei)
            cutscene:text("* " .. ralsei:getPartyMember().name .. ", huh? I like it!", "smile_b")
            cutscene:text("* Let's go, " .. Game:getPartyMember("kris").name .. "!", "smile")

            Game.world:transitionMusic(Game.world.map.music)

            ralsei:convertToFollower()
            rparty = ralsei:getPartyMember()
            rparty:setWeapon("red_scarf")
            Game:addPartyMember(rparty)
            cutscene:interpolateFollowers()
            event:setFlag("joined", true)
        elseif sel == 2 then
            cutscene:text("", "sad")
        end
    end
}
