local actor, super = Class(Actor, "toriel")

function actor:init()
    super.init(self)

    -- Display name (optional)
    self.name = "Toriel"

    -- Width and height for this actor, used to determine its center
    self.width = 25
    self.height = 53

    -- Hitbox for this actor in the overworld (optional, uses width and height by default)
    -- NOTE these are eyeballed and not accurate
    self.hitbox = {0, 30, 25, 23}

    -- Path to this actor's sprites (defaults to "")
    self.path = "npcs/toriel"
    -- This actor's default sprite or animation, relative to the path (defaults to "")
    self.default = "walk"

    -- Sound to play when this actor speaks (optional)
    self.voice = "toriel"
    -- Path to this actor's portrait for dialogue (optional)
    self.portrait_path = "face/toriel"
    -- Offset position for this actor's portrait (optional)
    --self.portrait_offset = {-19, -20}

    -- Whether this actor as a follower will blush when close to the player
    self.can_blush = false

    -- Table of sprite animations
    self.animations = {}

    -- Tables of sprites to change into in mirrors
    self.mirror_sprites = {
        ["walk/down"] = "walk/up",
        ["walk/up"] = "walk/down",
        ["walk/left"] = "walk/left",
        ["walk/right"] = "walk/right",
    }

    -- Table of sprite offsets (indexed by sprite name)
    --self.offsets = {
        -- Cutscene offsets
    --    ["shocked"] = {0, 0},
    --}
end

return actor
