
define MC_Name = "MC" 
define nvl_mode = "phone" 
default mina_enabled = False
default Alex_message = False #False 
default mina_unknown = True
default mina_message = False
default Alex_enabled = False #False
default nora_enabled = False #False
default nora_message = False
default uk_enabled = False
default uk_message = False
default blue_enabled = False
default blue_message = False
default dev_enabled = False
default dev_message = False
default queens_enabled = False #False    
default queens_message = False #False
default sam_enabled = False #False    
default sam_message = False #False

default chapter1_clear = False
default chapter2_clear = False
default chapter3_clear = False
default chapter4_clear = False
default chapter5_clear = False
default chapter6_clear = False
default chapter7_clear = False
default chapter8_clear = False

default first_start2 = True
default current_background = "UI/home_bg.png"
default current_background_preview_tag = "home_bg_preview"

image new_message = "/UI/new_message.png"

default _saved_afm_time         = 7.0
default _saved_afm_enable       = False
default skip_mode               = False
default afm_normal_time_seeded  = False
define NORMAL_AFM_DEFAULT       = 7.0
define MIN_SANE_AFM_TIME        = 0.20   # anything below this is skip like

init -2 python:
    config.keymap['game_menu'] = [k for k in config.keymap.get('game_menu', []) if k != 'mouseup_3']

    for k in ('hide_windows', 'rollback', 'rollforward'):
        config.keymap[k] = [x for x in config.keymap.get(k, []) if x != 'mouseup_3']

    if "rmb_to_settings" not in config.overlay_screens:
        config.overlay_screens.append("rmb_to_settings")

screen rmb_to_settings():
    key "mouseup_3" action ShowMenu("preferences")

init python:
    def _sanitize_normal_time(t):
        # if the captured time is unrealistically small, use project default
        return t if t >= MIN_SANE_AFM_TIME else NORMAL_AFM_DEFAULT

    def seed_normal_afm_time():
        if not store.afm_normal_time_seeded:
            t = getattr(preferences, "afm_time", NORMAL_AFM_DEFAULT)
            store._saved_afm_time = _sanitize_normal_time(t)
            store.afm_normal_time_seeded = True

    def set_fast_auto(on):
        """
        Skip-mode via AFM: set tiny delay while ON, restore previous AFM on OFF.
        """
        seed_normal_afm_time()

        afm_enable = getattr(preferences, "afm_enable", False)
        afm_time   = getattr(preferences, "afm_time",   NORMAL_AFM_DEFAULT)

        if on and not store.skip_mode:
            store._saved_afm_enable = afm_enable
            store._saved_afm_time   = _sanitize_normal_time(afm_time)
            setattr(preferences, "afm_enable", True)
            setattr(preferences, "afm_time",   0.02)  # ultra-fast
            store.skip_mode = True

        elif not on and store.skip_mode:
            setattr(preferences, "afm_enable", store._saved_afm_enable)
            setattr(preferences, "afm_time",   _sanitize_normal_time(store._saved_afm_time))
            store.skip_mode = False

    def toggle_auto_normal():
        """
        Toggle AFM, but when enabling, force a sane normal AFM speed (not 0.02).
        """
        seed_normal_afm_time()

        if getattr(preferences, "afm_enable", False):
            setattr(preferences, "afm_enable", False)
        else:
            setattr(preferences, "afm_time", _sanitize_normal_time(store._saved_afm_time))
            setattr(preferences, "afm_enable", True)
            
init python:
    def return_to_contacts():
        renpy.pause(0.0001) 
init python:
    def _trim_nvl(max_len=None):

        if max_len is None:
            max_len = renpy.store.max_messages
        try:
            nvl = renpy.store._nvl_list  # NVL buffer used by the nvl screen
            if len(nvl) > max_len:
                del nvl[:-max_len]
        except Exception:
            pass

transform phonePosition:
    xalign 1.0
    yalign 0.005

transform phonePosition2:
    xalign 1.0
    yalign 0.3

default currentCharacter = None
default currentLine = None
default lastLine = None

default max_messages = 50

init -1 python:

    def get_mouse():
        global mouse_xy
        mouse_xy = renpy.get_mouse_pos()

    def Phone_ReceiveSound(event, interact=True, **kwargs):
        if event == "show_done":
            renpy.sound.play("audio/ReceiveText.mp3")
            _trim_nvl()

    def Phone_SendSound(event, interact=True, **kwargs):
        if event == "show_done":
            renpy.sound.play("audio/SendText.mp3")
            _trim_nvl()

    def getLastLine():
        return getattr(store, '_last_raw_what', '')

label showPhone:
    show screen PhoneHomescreen
    return

label showContacts:
    hide screen messages
    show screen PhoneContacts
    return

default mouse_xy = (0, 0)

screen save_popup():

    timer 5.0 action [
        Function(renpy.notify, "Save warning! Please save now! 💾"),
        Function(renpy.sound.play, "audio/achievement.mp3"),
        SetVariable("first_start2", False),
        Hide("new_message_popup") 
    ]

screen PhoneHomescreen():
    zorder 1
    modal True
    add current_background at phonePosition2


    if first_start2:
        timer 3.0 action [
            Function(renpy.notify, "New message from Unknown Number"),
            Function(renpy.sound.play, "audio/new_message.mp3"),
            SetVariable("first_start2", False)
        ]

    grid 4 2:
        xalign 0.5
        yalign 2
        spacing 70
        top_margin 200

        imagebutton:
            auto "buttons/patreon_%s.png"
            action OpenURL("https://www.patreon.com/DramaticDonut")
            focus_mask True

        imagebutton:
            auto "buttons/substar_%s.png"
            action OpenURL("https://subscribestar.adult/dramaticdonut")
            focus_mask True
 
        imagebutton: 
            auto "buttons/settings_%s.png"
            action ShowMenu("preferences")

        imagebutton:
            auto "buttons/achievements_%s.png"
            action ShowMenu("Progress")

        imagebutton:
            auto "buttons/load_%s.png"
            action ShowMenu("load")

        null

        null

    add "UI/status_bar.png" xpos 0 ypos 0 xsize 1.0 ysize 126

    hbox:
        xalign 0.5
        yalign 1.0
        spacing 0

        frame:
            background Solid("#121212") 
            xsize 1.2  
            ysize 240  

            padding (30, 30)

            vbox:
                xalign 0.5
                yalign 0.5

                hbox: 
                    spacing 80

                    imagebutton:
                        auto "buttons/messenger_%s.png"
                        action [Hide("PhoneHomescreen"), Show("PhoneContacts")]

                    imagebutton:
                        auto "buttons/gallery_%s.png"
                        action [Hide("PhoneHomescreen"), Show("PhoneGallery")]

                    imagebutton:
                        auto "buttons/exit_%s.png"
                        action Quit(confirm = True)


screen PhoneContacts():
    zorder 1
    modal True
    add "UI/contacts_bg.png" at phonePosition

    grid 1 8:
        top_margin 250
        spacing 20

        if mina_unknown:
            imagebutton:
                ysize 200
                auto "UI/contact_bar_uk_%s.png"
                action [
                    Hide("PhoneContacts"), 
                    Call("character_history_load", "Unknown_Number"),
                    Show("messages"),
                ]

        python:
            mina_contact_image = "UI/contact_bar_message_mina_%s.png" if mina_message else "UI/contact_bar_mina_%s.png"
            Alex_contact_image = "UI/contact_bar_message_Alex_%s.png" if Alex_message else "UI/contact_bar_Alex_%s.png"
            nora_contact_image = "UI/contact_bar_message_nora_%s.png" if nora_message else "UI/contact_bar_nora_%s.png"
            uk_contact_image = "UI/contact_bar_message_uk_%s.png" if uk_message else "UI/contact_bar_uk_%s.png"
            blue_contact_image = "UI/contact_bar_message_blue_%s.png" if blue_message else "UI/contact_bar_blue_%s.png"
            dev_contact_image = "UI/contact_bar_message_dev_%s.png" if dev_message else "UI/contact_bar_dev_%s.png"
            queens_contact_image= "UI/contact_bar_message_queens_%s.png" if queens_message else "UI/contact_bar_queens_%s.png"
            sam_contact_image= "UI/contact_bar_message_sam_%s.png" if sam_message else "UI/contact_bar_sam_%s.png"


            mina_sensitivity = mina_message
            Alex_sensitivity = Alex_message
            nora_sensitivity = nora_message
            uk_sensitivity = uk_message
            blue_sensitivity = blue_message
            dev_sensitivity = dev_message
            queens_sensitivity = queens_message
            sam_sensitivity = sam_message

        if mina_enabled:
            imagebutton:
                ysize 200
                auto mina_contact_image
                sensitive mina_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "Mina"),
                    Call("character_history_load", "Mina"),
                    Show("messages"),
                ]

        if Alex_enabled:
            imagebutton:
                ysize 200
                auto Alex_contact_image
                sensitive Alex_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "Alex"),
                    Call("character_history_load", "Alex"),
                    Show("messages"),
                ]

        if nora_enabled:
            imagebutton:
                ysize 200
                auto nora_contact_image
                sensitive nora_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "Nora"),
                    Call("character_history_load", "Nora"),
                    Show("messages"),
                ]
        
        if uk_enabled:
            imagebutton:
                ysize 200
                auto uk_contact_image
                sensitive uk_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "uk"),
                    Call("character_history_load", "uk"),
                    Show("messages"),
                ]

        if blue_enabled:
            imagebutton:
                ysize 200
                auto blue_contact_image
                sensitive blue_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "Blue"),
                    Call("character_history_load", "Blue"),
                    Show("messages"),
                ]

        if dev_enabled:
            imagebutton:
                ysize 200
                auto dev_contact_image
                sensitive dev_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "dev"),
                    Call("character_history_load", "dev"),
                    Show("messages"),
                ]

        if queens_enabled:
            imagebutton:
                ysize 200
                auto queens_contact_image
                sensitive queens_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "queens"),
                    Call("character_history_load", "queens"),
                    Show("messages"),
                ]

        if sam_enabled:
            imagebutton:
                ysize 200
                auto sam_contact_image
                sensitive sam_sensitivity
                action [
                    Hide("PhoneContacts"),
                    SetVariable("currentCharacter", "Sam"),
                    Call("character_history_load", "Sam"),
                    Show("messages"),
                ]

    add "UI/status_bar.png" xpos 0 ypos 0 xsize 1.0 ysize 126

    imagebutton:
        xpos 15
        ypos 15
        auto "buttons/back_%s.png"
        action Hide("PhoneContacts"), Show("PhoneHomescreen")

screen messages(dialogue=None, items=None):
    style_prefix "phoneFrame"
    
    $ disable_rollforward = False
    $ auto_text = "Auto On" if getattr(preferences, "auto_forward", False) else "Auto"

    fixed:

        vbox:
            spacing 0
            frame:
                if items is not None and len(items) >= 2:
                    ysize 1600 - (len(items) - 2) * (120 + 10) - 20
                else:
                    ymaximum 1700

                viewport:
                    draggable True
                    mousewheel True
                    yinitial 1.0
                    vbox:
                        xalign 0.5
                        null height 120
                        if dialogue is not None and items is not None:
                            use nvl_phonetext(dialogue, items)
                        null height 100
                        null:
                            yfill True

            if items is not None and len(items) == 0:
                button:
                    padding (0, 0)
                    add "UI/message_bar.png"
                    action If(not disable_rollforward, RollForward())
            else:
                frame:
                    background Solid("#404040")
                    foreground None
                    vbox:
                        yalign 0.5
                        if items is not None:
                            for i in items:
                                button:
                                    action i.action
                                    xalign 0.5
                                    frame:
                                        background Solid("#eeeeee")
                                        hover_background Solid("#80acff")
                                        xysize (1000, 120)
                                        foreground None
                                        text i.caption:
                                            color "#000000"
                                            align (0.5, 0.5)
                                            text_align 0.5
                                            size 40

        add "UI/status_bar.png" xpos 0 ypos 0 xsize 1.0 ysize 126



        if show_back_button:
            imagebutton:
                xpos 15
                ypos 15
                auto "buttons/back_%s.png"
                action [
                    Hide("messages"),
                    Show("PhoneContacts"),
                    Call("history_save", currentCharacter),
                    SetVariable("currentLine", getattr(store, '_last_raw_what', ''))
                ]

    $ store._saved_afm_time = _sanitize_normal_time(getattr(preferences, "afm_time", NORMAL_AFM_DEFAULT)) if not skip_mode else store._saved_afm_time

    textbutton "Save" action [Hide("messages"), ShowMenu("save")] style "auto_toggle_button" xpos 100 ypos 20
    textbutton "Load" action [Hide("messages"), ShowMenu("load")] style "auto_toggle_button" xpos 300 ypos 20

    $ auto_active = getattr(preferences, "afm_enable", False)
    $ auto_text = "Auto On" if auto_active else "Auto"

    if not skip_mode:
        textbutton auto_text:
            selected auto_active                
            action Function(toggle_auto_normal)
            style "auto_toggle_button"
            xpos 500
            ypos 20
    else:
        text "":
            xpos 500
            ypos 20   


    if (not auto_active) or skip_mode:
        textbutton ("Skip on" if skip_mode else "Skip"):
            selected skip_mode             
            action Function(set_fast_auto, not skip_mode)
            style "auto_toggle_button"
            xpos 700
            ypos 20
    else:
        text "":
            xpos 700
            ypos 20  

style auto_toggle_button:
    background None
    padding (5, 5, 5, 5)
    size 30

style auto_toggle_button_text:
    color "#FFF"
    hover_color "#1d00a0"
    selected_color "#1d00a0"
    selected_hover_color "#1d00a0"


screen nvl_phonetext(dialogue,items):
    style_prefix None


    # Only render the last N messages
    $ _dlg = dialogue[-max_messages:]

    python:
        if currentLine is not None:
            for line in _dlg:
                if currentLine != line:
                    RollForward()
                else:
                    break

    # python:
    #     if currentLine is not None:
    #         for line in dialogue:

    #             if currentLine != line:
    #                 RollForward()
    #             else:

    #                 break                

    $ previous_d_who = None
    for id_d, d in enumerate(_dlg):    
    # for id_d, d in enumerate(dialogue):
        if d.who == None: 
            null height 30
            text d.what:
                    xalign 0.5
                    ypos 0.0
                    xsize 650
                    color "#B6C3D4"
                    text_align 0.5
                    # italic True
                    bold True
                    size 40
                    slow_cps False
                    id d.what_id

                    # OUTCOMMENT FOR WEB APPLICATION 
                    if d.current and len(items)==0:
                        at message_narrator

            null height 30
        elif d.who == 'System': 
            null height 30
            text d.what:
                    xalign 0.5
                    ypos 0.0
                    xsize 650
                    color "#b809F5"
                    text_align 0.5
                    size 40
                    slow_cps False
                    id d.what_id
                    if d.current and len(items)==0:
                        at message_narrator
                    at transform:
                        pause 0.5

            null height 30
        else:
            if d.who == MC_Name:
                $ message_frame = "phone_send_frame.png"
            else:
                $ message_frame = "phone_received_frame.png"

            hbox:
                spacing 10
                if d.who == MC_Name:
                    box_reverse True
                    xalign 1.0
                
                if previous_d_who != d.who:
                    if d.who == MC_Name:
                        $ message_icon = "UI/mc_icon.png"
                    elif d.who == "Unknown Number":
                        $ message_icon = "UI/uk_icon.png"
                    elif d.who == "Mina":
                        $ message_icon = "UI/mina_icon.png"
                    elif d.who == "Alex":
                        $ message_icon = "UI/Alex_icon.png"
                    elif d.who == "Blue":
                        $ message_icon = "UI/blue_icon.png"
                    elif d.who == "Nora":
                        $ message_icon = "UI/Nora_icon.png"
                    elif d.who == "DramaticDonut(Dev)":
                        $ message_icon = "UI/dev_icon.png"
                    elif d.who == "Sam":
                        $ message_icon = "UI/sam_icon.png"
                    else:
                        $ message_icon = "phone_received_icon.png"


                    # FOR WEB APPLICATION:
                    # add message_icon

                    add message_icon:
                        if d.current  and len(items)==0:
                            at message_appear_icon()
                        
                else:
                    null width 107

                vbox:
                    yalign 1.0
                    if d.who != MC_Name and previous_d_who != d.who:
                        text d.who:
                            size 30
                            color "#DADADA"

                    frame:
                        padding (20,20)
                        background Frame(message_frame, 23,23,23,23)
                        xsize 650

                        #FOR WEB APLICATION:
                        # if d.current and len(items)==0:
                        #     pass  

                        if d.current and len(items)==0:
                            if d.who == MC_Name:
                                at message_appear(1)
                            else:
                                at message_appear(-1)

                        text d.what:
                            pos (0,0)
                            xsize 650
                            slow_cps False
                            size 45
                            

                            if d.who == MC_Name :
                                color "#FFF"
                                text_align 1.0
                                xanchor 1.0
                                xpos 1.0
                            else:
                                color "#FFF"

                                
                            id d.what_id
        $ previous_d_who = d.who
                    
style phoneFrame is default

style phoneFrame_frame:
    background "UI/base_bg.png"
    foreground "messenger_fg.png"
    
    yfill True
    xfill True


    padding (20,0)


style phoneFrame_viewport:
    yfill True
    xfill True


style phoneFrame_vbox:
    spacing 10
    xfill True

style phoneChoice


transform phone_transform(pXalign=0.5, pYalign=0.5):
    xcenter pXalign
    yalign pYalign

transform phone_appear(pXalign=0.5, pYalign=0.5): 
    xcenter pXalign
    yalign pYalign

    on show:
        yoffset 1080
        easein_back 1.0 yoffset 0

    
transform message_appear(pDirection):
    alpha 0.0
    xoffset 50 * pDirection
    parallel:
        ease 0.4 alpha 1.0
    parallel:
        easein_back 0.4 xoffset 0

transform message_appear_icon():
    zoom 0.0
    easein_back 0.5 zoom 1.0

transform message_narrator:
    alpha 0.0
    yoffset -50

    parallel:
        ease 0.5 alpha 1.0
    parallel:
        easein_back 0.5 yoffset 0

screen enterName:
    add "UI/base_bg.png" at phonePosition

    vbox:
        xalign 0.5
        yalign 0.4
        text "What's your name?": 
            color "#FFF"
            size 50 
            at transform:
                    alpha 0 
                    center
                    pause 0.2
                    linear 2 alpha 1.0

        null height 30

        input default "":
            color "#d1d1d1"
            size 40
            pixel_width(800)
            value VariableInputValue("player")
            at transform:
                    center

        null height 20

        textbutton "OK":
            text_size 20
            action Hide("enterName"), Show("messages"), Jump("Mom_2")
            keysym('K_RETURN', 'K_KP_ENTER')
            at transform:
                    center

    add "UI/status_bar.png" xpos 0 ypos -0 xsize 1.0 ysize 126


screen ending(endingText):
    add "UI/base_bg.png" at phonePosition

    vbox:
        xalign 0.5
        yalign 0.5
        text (endingText):
            color "#FFF"
            size 50 
            at transform:
                    alpha 0 
                    center
                    pause 0.2
                    linear 2 alpha 1.0

        null height 30

        hbox:
            xalign 0.9
            textbutton "Play again?":
                text_size 30
                action Hide("ending"), Show("messages"), Jump("start")
                at transform:
                        alpha 0 
                        center
                        pause 0.3
                        linear 2 alpha 1.0

            textbutton "Quit":
                text_size 30
                xoffset 20
                action Quit(confirm = True)
                at transform:
                        alpha 0 
                        center
                        pause 0.3
                        linear 2 alpha 1.0

screen Progress():
    zorder 1
    modal True
    add "UI/progress_bg.png" at phonePosition

    grid 1 10:
        top_margin 250
        spacing 15

        python:
            chapter1_image = "UI/progress/chapter1.png" if chapter1_clear else "UI/progress/chapter_closed.png"
            chapter2_image = "UI/progress/chapter2.png" if chapter2_clear else "UI/progress/chapter_closed.png"
            chapter3_image = "UI/progress/chapter3.png" if chapter3_clear else "UI/progress/chapter_closed.png"
            chapter4_image = "UI/progress/chapter4.png" if chapter4_clear else "UI/progress/chapter_closed.png"
            chapter5_image = "UI/progress/chapter5.png" if chapter5_clear else "UI/progress/chapter_closed.png"

        add chapter1_image:
            ysize 120

        add chapter2_image:
            ysize 120

        add chapter3_image:
            ysize 120

        add chapter4_image:
            ysize 120

        add chapter5_image:
            ysize 120

    add "UI/status_bar.png" xpos 0 ypos 0 xsize 1.0 ysize 126

    imagebutton:
        xpos 15
        ypos 15
        auto "buttons/back_%s.png"
        action Return()


default snapgram_selected_user = "All"

default snapgram_display_names = {
    "All": "All",
    "Mina": "@Minii",
    "Alex": "@AlexIsFirst",
    "Nora": "@NoRawr",
}


default snapgram_profiles = {
    "Mina": {
        "caption": "Mina • dancing, overthinking, and missing him a little too much 💕",
    },
    "Alex": {
        "caption": "Alex • chaos in heels, professional bad influence 💄",
    },
    "Nora": {
        "caption": "Nora • quiet corner, loud playlists, soft thoughts 📚",
    },
}

default snapgram_posts = [
    {
        "image": "CGs/large/mina4_favorite1.png",
        "user": "Mina",
        "caption": "Throwback to the lake trip ❤️",
        "comments": [
            {"user": "Alex", "text": "Cute 😍"},
            {"user": "Nora", "text": "I remember that day 🌿"},
        ]
    },

    {
        "image": "CGs/large/Alex4_car.png",
        "user": "Alex",
        "caption": "On the way to the show! 💅💗",
        "comments": [
            {"user": "Mina", "text": "Behave 😒😂"},
        ]
    },

    {
        "image": "CGs/large/Alex_21_bathtub.png",
        "user": "Alex",
        "caption": "Self-care or self-chaos? You decide 💋🛁",
        "comments": [
            {"user": "Mina", "text": "You're gonna drown one day 😭"},
            {"user": "Nora", "text": "chaos floats"},
        ]
    },

    {
        "image": "CGs/large/nora_14_breakfast.png",
        "user": "Nora",
        "caption": "quiet morning. good food. sunlight. perfect. ☕📖",
        "comments": [
            {"user": "Mina", "text": "I want breakfast like THAT 😭"},
            {"user": "Alex", "text": "Marry me???"},
        ]
    },

    {
        "image": "CGs/large/mina_14_cafe.png",
        "user": "Mina",
        "caption": "Morning shift 🤍 If you order six caramel lattes in a row... I WILL judge you.",
        "comments": [
            {"user": "Alex", "text": "No you won't you love us 😌"},
            {"user": "Nora", "text": "caramel is justice"},
        ]
    }

]

screen SnapGram():
    tag phone
    zorder 100
    modal True

    # Fullscreen background
    frame:
        background Solid("#000000")
        xfill True
        yfill True

    # Status bar
    add "UI/status_bar.png" xpos 0 ypos 0 ysize 126

    # ---------------------------------------------------------
    # TOP STORIES / PROFILE NAV BAR (All + Mina + Alex + Nora)
    # ---------------------------------------------------------
    frame:
        xpos 0
        ypos 126
        xfill True
        ysize 160
        background Solid("#111111")

        hbox:
            spacing 30
            xalign 0.075
            yalign 0.5

            # "All" + 3 profiles
            $ _profiles = ["All", "Mina", "Alex", "Nora"]

            for name in _profiles:
                $ selected = (snapgram_selected_user == name)
                $ bg_color = Solid("#254f9d") if selected else Solid("#222222")

                # Use different source images:
                if name == "All":
                    # special icon just for "All"
                    $ icon = "UI/snap_All_placeholder.png"
                else:
                    # use the big profile pictures for Mina / Alex / Nora
                    $ icon = "UI/profile_%s.png" % name

                frame:
                    xsize 130
                    ysize 130
                    xpadding 10
                    ypadding 10
                    background bg_color

                    imagebutton:
                        idle Transform(icon, xsize=100, ysize=100)
                        hover Transform(icon, xsize=100, ysize=100)
                        action SetVariable("snapgram_selected_user", name)
                        xalign 0.5
                        yalign 0.5


    # ---------------------------------------------------------
    # FEED / PROFILE CONTENT
    # ---------------------------------------------------------

    # Filter posts based on selected profile
    python:
        if snapgram_selected_user == "All":
            filtered_posts = snapgram_posts[:]
        else:
            filtered_posts = [p for p in snapgram_posts if p["user"] == snapgram_selected_user]

    viewport:
        xpos 0
        ypos 126 + 160          # status + stories bar
        xsize config.screen_width
        ysize config.screen_height - (126 + 160)
        draggable True
        mousewheel True
        scrollbars None

        vbox:
            spacing 20
            xalign 0.5
            xsize config.screen_width

            # PROFILE HEADER (only if a specific user selected)
            if snapgram_selected_user != "All":
                $ profile_data = snapgram_profiles.get(snapgram_selected_user, {})
                $ post_count = len(filtered_posts)
                $ profile_icon = "UI/profile_%s.png" % snapgram_selected_user

                hbox:
                    spacing 40
                    xalign 0.0
                    xpos 40
                    ypos 40

                    # LEFT: scaled 250x250 profile picture
                    frame:
                        background None
                        xsize 250
                        ysize 250
                        add Transform(profile_icon, xsize=250, ysize=250, xalign=0.0, yalign=0.5)

                    # RIGHT SIDE: vertical caption block, centered to image
                    vbox:
                        spacing 12
                        yalign 0.5

                        # NEW: Large, bold profile name
                        text snapgram_display_names.get(snapgram_selected_user, snapgram_selected_user):
                            color "#FFFFFF"
                            size 60
                            bold True
                            xalign 0.0

                        # Caption
                        text profile_data.get("caption", snapgram_selected_user):
                            color "#FFFFFF"
                            size 40
                            xalign 0.0

                        # Post count
                        text "Posts: [post_count]":
                            color "#BBBBBB"
                            size 34
                            xalign 0.0

                null height 40


            # POSTS
            for post in filtered_posts:

                frame:
                    xfill True
                    background Solid("#1a1a1a")
                    top_padding 30
                    bottom_padding 30

                    vbox:
                        spacing 16
                        xalign 0.5
                        xsize config.screen_width

                        # IMAGE FIRST
                        add Transform(post["image"], xalign=0.5, xsize=config.screen_width)

                        # NAME BELOW IMAGE – bigger + bold
                        text snapgram_display_names.get(post["user"], post["user"]):
                            color "#FFFFFF"
                            size 48
                            bold True
                            xpos 40

                        # CAPTION BELOW NAME – smaller, regular
                        text post["caption"]:
                            color "#DDDDDD"
                            size 36
                            xpos 40

                        # COMMENTS
                        if post["comments"]:
                            vbox:
                                spacing 8
                                xpos 40
                                for c in post["comments"]:
                                    text "[c['user']]: [c['text']]":
                                        color "#AAAAAA"
                                        size 32


    # Back button
    imagebutton:
        xpos 15
        ypos 15
        auto "buttons/back_%s.png"
        action Hide("SnapGram"), Show("PhoneHomescreen")




# $ snapgram_posts.insert(0, new_post_dict)
# $ renpy.notify("Mina posted a new SnapGram photo!")