# List to track unlocked gallery images
default unlocked_gallery_images = []

init python:
    def _show_confirm_dialog(image_path):
        renpy.show_screen("confirm_dialog", image_path=image_path)


# Function to unlock an image
init python:
    def unlock_image(image_name):
        if image_name not in unlocked_gallery_images:
            unlocked_gallery_images.insert(0, image_name)

default gallery_open = False


screen confirm_dialog(image_path):
    modal True
    zorder 300

    frame:
        background Solid("#222222")
        xalign 0.5
        yalign 0.5
        padding 20

        vbox:
            spacing 20
            text "Do you want to set this image as your phone background?":
                align (0.5, 0.5)

            hbox:
                spacing 20
                textbutton "Yes" action [
                    SetVariable("current_background", image_path),
                    Hide("confirm_dialog")
                ]

                textbutton "No" action Hide("confirm_dialog")

screen PhoneGallery:
    zorder 100  # Ensure it renders above other elements
    modal True  # Prevent interaction with other screens

    # Black background
    frame:
        background Solid("#000000")  # Solid black background
        xfill True
        yfill True

    # Status bar
    add "UI/status_bar.png" xpos 0 ypos 0 xsize 1.0 ysize 126

    # Scrollable grid for gallery items
    vpgrid:
        cols 3
        spacing 20
        draggable True
        mousewheel True

        ypos 110
        xmargin 20
        ymargin 10

        for image_name in unlocked_gallery_images:
            imagebutton:
                idle f"CGs/small/{image_name}_small.png"
                hover f"CGs/small/{image_name}_small.png"
                action Show("gallery_image_view", image_path=f"CGs/large/{image_name}.png")

    # Button to return to the home screen
    imagebutton:
        xpos 15
        ypos 15
        auto "buttons/back_%s.png"
        action Hide("PhoneGallery"), Show("PhoneHomescreen")

screen gallery_image_view(image_path):
    modal True
    zorder 200

    # Background button to close the view
    button:
        background Solid("#000000AA")
        xfill True
        yfill True
        action Hide("gallery_image_view")

    # Display the enlarged image
    add image_path:
        xalign 0.5
        yalign 0.3

    # Back button for manual closing
    imagebutton:
        xpos 15
        ypos 15
        auto "buttons/back_%s.png"
        action Hide("gallery_image_view")

    frame:
        xpos 0.5
        ypos 0.9
        xanchor 0.5
        yanchor 0.05
        padding (5, 5)
        background Solid("#3c3331ff")

        textbutton "{color=#FFFFFF}Set as Wallpaper{/color}":
            text_size 50
            xalign 0.5
            yalign 0.5
            padding (30, 40)
            background Solid("#3c3331ff")
            hover_background Solid("#000e75")
            action Confirm(
                "Do you want to set this image as your phone background?",
                yes=[
                    SetVariable("current_background", image_path),
                    Hide("gallery_image_view"),
                    Hide("PhoneHomescreen"),
                    Show("PhoneHomescreen")
                ],
                no=Return()
            )


init python:
    gallery = Gallery()

    gallery.button("mina1")
    gallery.image("mina1.png")
    gallery.condition("persistent.mina1_unlocked")

    gallery.button("Alexyoga1")
    gallery.image("Alex/Alexyoga1.png")
    gallery.condition("persistent.Alexyoga1_unlocked")

    gallery.button("mina2_cute")
    gallery.image("CGs/large/mina2_cute.png")
    gallery.condition("persistent.mina2_cute_unlocked")

    gallery.button("mina3_training")
    gallery.image("CGs/large/mina3_training.png")
    gallery.condition("persistent.mina3_training_unlocked")

    gallery.button("mina4_mc_favorite1")
    gallery.image("CGs/large/mina4_mc_favorite1.png")
    gallery.condition("persistent.mina4_mc_favorite1_unlocked")

    gallery.button("mina4_favorite1")
    gallery.image("CGs/large/mina4_favorite1.png")
    gallery.condition("persistent.mina4_favorite1_unlocked")
