SMODS.Atlas({
    key = "modicon", 
    path = "ModIcon.png", 
    px = 34,
    py = 34,
    atlas_table = "ASSET_ATLAS"
})

SMODS.Atlas({
    key = "balatro", 
    path = "balatro.png", 
    px = 333,
    py = 216,
    prefix_config = { key = false },
    atlas_table = "ASSET_ATLAS"
})


SMODS.Atlas({
    key = "CustomJokers", 
    path = "CustomJokers.png", 
    px = 71,
    py = 95, 
    atlas_table = "ASSET_ATLAS"
})

local NFS = require("nativefs")
to_big = to_big or function(a) return a end
lenient_bignum = lenient_bignum or function(a) return a end

local jokerIndexList = {24,34,50,38,54,3,45,43,46,61,5,39,42,59,25,47,29,1,40,14,6,21,26,11,27,9,51,36,15,53,18,12,20,13,7,58,56,41,16,2,48,4,37,8,30,23,17,28,55,31,22,10,32,19,33,57,35,49,60,44,52}

local function load_jokers_folder()
    local mod_path = SMODS.current_mod.path
    local jokers_path = mod_path .. "/jokers"
    local files = NFS.getDirectoryItemsInfo(jokers_path)
    for i = 1, #jokerIndexList do
        local file_name = files[jokerIndexList[i]].name
        if file_name:sub(-4) == ".lua" then
            assert(SMODS.load_file("jokers/" .. file_name))()
        end
    end
end

function SMODS.current_mod.reset_game_globals(run_start)
    local jokerPool = {}
    for k, v in pairs(G.P_CENTERS) do
        if v.set == 'Joker' then
            if (not v.mod) then
                G.GAME.banned_keys[k] = true
            end
        end
    end
end

load_jokers_folder()
SMODS.ObjectType({
    key = "kamenrider_food",
    cards = {
        ["j_gros_michel"] = true,
        ["j_egg"] = true,
        ["j_ice_cream"] = true,
        ["j_cavendish"] = true,
        ["j_turtle_bean"] = true,
        ["j_diet_cola"] = true,
        ["j_popcorn"] = true,
        ["j_ramen"] = true,
        ["j_selzer"] = true
    },
})

SMODS.ObjectType({
    key = "kamenrider_kamenrider_jokers",
    cards = {
        ["j_kamenrider_agito"] = true,
        ["j_kamenrider_alpha"] = true,
        ["j_kamenrider_birth"] = true,
        ["j_kamenrider_black"] = true,
        ["j_kamenrider_blade"] = true,
        ["j_kamenrider_build"] = true,
        ["j_kamenrider_changerion"] = true,
        ["j_kamenrider_decade"] = true,
        ["j_kamenrider_deneb"] = true,
        ["j_kamenrider_deno"] = true,
        ["j_kamenrider_drive"] = true,
        ["j_kamenrider_exaid"] = true,
        ["j_kamenrider_faiz"] = true,
        ["j_kamenrider_fourze"] = true,
        ["j_kamenrider_g"] = true,
        ["j_kamenrider_g3"] = true,
        ["j_kamenrider_gaim"] = true,
        ["j_kamenrider_garren"] = true,
        ["j_kamenrider_ghost"] = true,
        ["j_kamenrider_hibiki"] = true,
        ["j_kamenrider_hojo"] = true,
        ["j_kamenrider_homophobia"] = true,
        ["j_kamenrider_j"] = true,
        ["j_kamenrider_kabuto"] = true,
        ["j_kamenrider_kiva"] = true,
        ["j_kamenrider_kivala"] = true,
        ["j_kamenrider_kuuga"] = true,
        ["j_kamenrider_leangle"] = true,
        ["j_kamenrider_meteorstorm"] = true,
        ["j_kamenrider_mezool"] = true,
        ["j_kamenrider_nadeshiko"] = true,
        ["j_kamenrider_odin"] = true,
        ["j_kamenrider_ooo"] = true,
        ["j_kamenrider_quiz"] = true,
        ["j_kamenrider_rx"] = true,
        ["j_kamenrider_ryuki"] = true,
        ["j_kamenrider_shin"] = true,
        ["j_kamenrider_shinprologue"] = true,
        ["j_kamenrider_skyrider"] = true,
        ["j_kamenrider_specter"] = true,
        ["j_kamenrider_stronger"] = true,
        ["j_kamenrider_super1"] = true,
        ["j_kamenrider_tackle"] = true,
        ["j_kamenrider_thefirst"] = true,
        ["j_kamenrider_urataros"] = true,
        ["j_kamenrider_w"] = true,
        ["j_kamenrider_wiseman"] = true,
        ["j_kamenrider_wizard"] = true,
        ["j_kamenrider_zeronos"] = true,
        ["j_kamenrider_zeroone"] = true,
        ["j_kamenrider_zerotwo"] = true,
        ["j_kamenrider_zio"] = true,
        ["j_kamenrider_zo"] = true,
        ["j_kamenrider_zubat"] = true,
        ["j_kamenrider_zx"] = true
    },
})

SMODS.ObjectType({
    key = "kamenrider_mycustom_jokers",
    cards = {
        ["j_kamenrider_amazon"] = true,
        ["j_kamenrider_ichigo"] = true,
        ["j_kamenrider_niigo"] = true,
        ["j_kamenrider_riderman"] = true,
        ["j_kamenrider_v3"] = true,
        ["j_kamenrider_x"] = true
    },
})


SMODS.current_mod.optional_features = function()
    return {
        cardareas = {} 
    }
end