
SMODS.Joker{ --Den-O
    key = "deno",
    config = {
        extra = {
            chips0 = 30
        }
    },
    loc_txt = {
        ['name'] = 'Den-O',
        ['text'] = {
            [1] = 'Random suit chosen every',
            [2] = 'round. Every card in that',
            [3] = 'suit gets {C:blue}+30{} Chips when scored.',
            [4] = 'Currently #1#.'
        },
        ['unlock'] = {
            [1] = 'Unlocked by default.'
        }
    },
    pos = {
        x = 3,
        y = 2
    },
    display_size = {
        w = 71 * 1, 
        h = 95 * 1
    },
    cost = 6,
    rarity = 2,
    blueprint_compat = true,
    eternal_compat = true,
    perishable_compat = true,
    unlocked = true,
    discovered = true,
    atlas = 'CustomJokers',
    pools = { ["kamenrider_kamenrider_jokers"] = true },
    
    loc_vars = function(self, info_queue, card)
        
        return {vars = {localize((G.GAME.current_round.SuitType_card or {}).suit or 'Spades', 'suits_singular')}, colours = {G.C.SUITS[(G.GAME.current_round.SuitType_card or {}).suit or 'Spades']}}
    end,
    
    set_ability = function(self, card, initial)
        G.GAME.current_round.SuitType_card = { suit = 'Hearts' }
    end,
    
    calculate = function(self, card, context)
        if context.first_hand_drawn  then
            if G.playing_cards then
                local valid_SuitType_cards = {}
                for _, v in ipairs(G.playing_cards) do
                    if not SMODS.has_no_suit(v) then
                        valid_SuitType_cards[#valid_SuitType_cards + 1] = v
                    end
                end
                if valid_SuitType_cards[1] then
                    local SuitType_card = pseudorandom_element(valid_SuitType_cards, pseudoseed('SuitType' .. G.GAME.round_resets.ante))
                    G.GAME.current_round.SuitType_card.suit = SuitType_card.base.suit
                end
            end
        end
        if context.individual and context.cardarea == G.play  then
            if context.other_card:is_suit(G.GAME.current_round.SuitType_card.suit) then
                return {
                    chips = 30
                }
            end
        end
    end
}