# AI Equipment Designs

These scripts are used to direct AI to create equipment variants and upgrade
existing equipment in order to satisfy specific role needs.  Equipment type and
equipment module specifications determine what is necessary and desirable for
filling particular roles, and priority triggers provide additional hooks to
encourage the AI in different directions.


## Syntax
```
<AI design group name> = {
	# naval category is supported from version 1.6.0, and land category from version 1.11.0
	category = <equipment category>

	# Exclusionary list of countries that will not use this design group.
	blocked_for = {
		# country tags...
	}
	
	# Inclusionary list of countries that will use this design group.
	# If this list is empty, all countries not in the block list will be allowed.
	# If this list is not empty, only countries that are in this list and not in the blocked list will be allowed.
	available_for = {
		# country tags...
	}
	
	# List of roles that this design group can be used for.
	# AI will attempt to design and produce equipment to satisfy all roles that it can.
	# So it will try to actively use one design per role for new production and upgrading/refitting.
	# roles here are dynamically generated and should work with role_ratio ai_strategy
	roles = {
		# roles...
	}
	
	# Base priority for creating a design in this group or for creating or upgrading equipment to use one of these designs. A higher number means higher priority.
	priority = {
		factor = <numeric weight>
		# Zero or more weighted modifiers to affect priority based on triggers.
		modifier = {
			factor = <numeric weight>
			# triggers...
		}
	}
	
	# One or more specifications of designs belonging to this design group.
	<AI design name> = {
		# Further priority for creating this design specifically or for creating or upgrading equipment to use this design.
		priority = {
			factor = <numeric weight>
			# Zero or more weighted modifiers to affect priority based on triggers.
			modifier = {
				factor = <numeric weight>
				# triggers...
			}
		}
		
		# List of triggers that must all be true for the design to be usable; true by default if empty or missing.
		enable = {
			# triggers...
		}
		
		# Specifications about how a matching equipment variant should be designed.
		target_variant = {
			# An additional weight indicating how much the particular design is worth, if it matches.
			match_value = <numeric weight>
			
			# The equipment archetype or equipment type that the variant must use to match.
			type = <equipment archetype or type>
			
			# The matching requirements on individual module slots.
			modules = {
				# A slot can be assigned a module category.  Any other module category fails the match.
				# When designing an equipment variant, the latest available will be favored.
				<slot> = <module category>
				
				# A slot can be assigned a specific module.  Any other module fails the match.
				<slot> = <module>
				
				# Less than and greater than comparisons can be used to force lesser or greater modules within a chain of module upgrades.
				# When designing an equipment variant, the earliest module will be favored for the lesser restriction, and the latest will be favored for the greater restriction.
				<slot> < <module>
				<slot> > <module>
				
				# A slot can be assigned empty.  Any module of any kind fails the match.
				<slot> = empty
				
				# A slot can be greater than empty.  Only an empty slot fails the match.
				<slot> > empty
				
				# A slot can refer to a nested group of more detailed requirements.
				<slot> = {
					# As above, you can specify a module category, or an equal, lesser, or greater module, or empty/non-empty.
					module = <module category>
					# -or-
					module = <module>
					# -or-
					module < <module>
					# -or-
					module > <module>
					# -or-
					module = empty
					# -or-
					module > empty
					
					# Or you can provide a list of modules or module categories, any of which are sufficient for a match.
					any_of = { [modules or module categories...] }
					
					# If you provide multiple instances of module attributes or any_of attributes, then only one must match for the match to succeed.
					
					# Optionally, for upgrading existing equipment to a this design, you can require that this slot must have a better module in order to use this design.
					upgrade > current
					# Alternatively, you can require that it must use exactly the same module that is already on the existing equipment.
					upgrade = current
				}
			}
		}
		
		# List of hard requirements that all must match for this design to be usable.
		# These follow the same pattern as a slot entry above within target_variant = { modules = { ... } },
		# but without being tied to an individual slot.
		requirements = {
			module = <requirements>
		}
		
		# Additional modules that are allowed in any available slots for any of the above designs, after all requirements are fulfilled.
		# Modules at the top of this list are favored over those at the bottom.
		# Modules not in this list will not be used in any remaining open slots.
		allowed_modules = {
			# modules or module categories...
		}
	}
}
```
