﻿; The CMD file.


;-| Button Remapping |-----------------------------------------------------
; This section lets you remap the player's buttons (to easily change the
; button configuration). The format is:
;   old_button = new_button
; If new_button is left blank, the button cannot be pressed.
[Remap]
x = x
y = y
z = z
a = a
b = b
c = c
s = s

;-| Default Values |-------------------------------------------------------
[Defaults]
; Default value for the "time" parameter of a Command. Minimum 1.
command.time = 15

; Default value for the "buffer.time" parameter of a Command. Minimum 1,
; maximum 30.
command.buffer.time = 1


;-| Super Motions |--------------------------------------------------------

[Command]  ;インチキFRB
name = "intiki_FRB_b"
command = b

[Command]  ;インチキFRB
name = "intiki_FRB_a"
command = a

[Command]  ;FRB
name = "FRB_b"
command = D,$F,U,$B, D,$F,U,$B, b
time = 120
[Command]
name = "FRB_a"
command = D,$F,U,$B, D,$F,U,$B, a
time = 120
[Command]
name = "FRB_b"
command = D,$B,U,$F, D,$B,U,$F, b
time = 120
[Command]
name = "FRB_a"
command = D,$B,U,$F, D,$B,U,$F, a
time = 120

[Command]  ;FRB
name = "FRB_b"
command = F,$U,B,$D, F,$U,B,$D, F,$U,B,$D, b
time = 120
[Command]
name = "FRB_a"
command = F,$U,B,$D, F,$U,B,$D, F,$U,B,$D, a
time = 120
[Command]
name = "FRB_b"
command = F,$D,B,$U, F,$D,B,$U, b
[Command]
name = "FRB_a"
command = F,$D,B,$U, F,$D,B,$U, a

[Command]  ;FRB
name = "FRB_b"
command = U,$B,D,$F, U,$B,D,$F, b
time = 120
[Command]
name = "FRB_a"
command = U,$B,D,$F, U,$B,D,$F, a
time = 120
[Command]
name = "FRB_b"
command = U,$F,D,$B, U,$F,D,$B, b
time = 120
[Command]
name = "FRB_a"
command = U,$F,D,$B, U,$F,D,$B, a
time = 120

[Command]  ;FRB
name = "FRB_b"
command = B,$D,F,$U, B,$D,F,$U, b
time = 120
[Command]
name = "FRB_a"
command = B,$D,F,$U, B,$D,F,$U, a
time = 120
[Command]
name = "FRB_b"
command = B,$U,F,$D, B,$U,F,$D, b
time = 120
[Command]
name = "FRB_a"
command = B,$U,F,$D, B,$U,F,$D, a
time = 120

[Command]  ;HAARP
name = "5252y+b"
command = $D, ~$D, $D, y+b
time = 60
[Command]  ;HAARP
name = "5252y+b"
command = $D, ~$D, $D, z+c
time = 60
[Command]  ;プロトンアーク
name = "5252x+a"
command = $D, ~$D, $D, x+a
time = 60


;-| Ex Special Motions |------------------------------------------------------

[Command]  ;MK_ultra
name = "MK_ultra"
command = D,$F,U,$B, a+b
time = 60
[Command]
name = "MK_ultra"
command = D,$F,U,$B, c
time = 60
[Command]
name = "MK_ultra"
command = D,$B,U,$F, a+b
time = 60
[Command]
name = "MK_ultra"
command = D,$B,U,$F, c
time = 60

[Command]  ;MK_ultra
name = "MK_ultra"
command = F,$U,B,$D, a+b
time = 60
[Command]
name = "MK_ultra"
command = F,$U,B,$D, c
time = 60
[Command]
name = "MK_ultra"
command = F,$D,B,$U, a+b
[Command]
name = "MK_ultra"
command = F,$D,B,$U, c

[Command]  ;MK_ultra
name = "MK_ultra"
command = U,$B,D,$F, a+b
time = 60
[Command]
name = "MK_ultra"
command = U,$B,D,$F, c
time = 60
[Command]
name = "MK_ultra"
command = U,$F,D,$B, a+b
time = 60
[Command]
name = "MK_ultra"
command = U,$F,D,$B, c
time = 60

[Command]  ;MK_ultra
name = "MK_ultra"
command = B,$D,F,$U, a+b
time = 60
[Command]
name = "MK_ultra"
command = B,$D,F,$U, c
time = 60
[Command]
name = "MK_ultra"
command = B,$U,F,$D, a+b
time = 60
[Command]
name = "MK_ultra"
command = B,$U,F,$D, c
time = 60

[Command]  ;MK_ultra
name = "MK_ultra"
command = D,$F,U,$B, y+b
time = 60
[Command]
name = "MK_ultra"
command = D,$B,U,$F, y+b
time = 60
[Command]  ;MK_ultra
name = "MK_ultra"
command = F,$U,B,$D, y+b
time = 60
time = 60
[Command]
name = "MK_ultra"
command = F,$D,B,$U, y+b
[Command]  ;MK_ultra
name = "MK_ultra"
command = U,$B,D,$F, y+b
time = 60
[Command]
name = "MK_ultra"
command = U,$F,D,$B, y+b
time = 60
[Command]  ;MK_ultra
name = "MK_ultra"
command = B,$D,F,$U, y+b
time = 60
time = 60
[Command]
name = "MK_ultra"
command = B,$U,F,$D, y+b
time = 60


[Command]  ;ブルービーム
name = "blue_beam"
command = ~28$D, $U, x+y
time = 50
[Command]  ;
name = "blue_beam"
command = ~28$D, $U, x+a
time = 50
[Command]  ;
name = "blue_beam"
command = ~28$D, $U, z
time = 50

[Command]  ;これはキャベツです。
name = "hakusai"
command = x+y, x+y, x+y, x+y
time = 40
[Command]  ;
name = "hakusai"
command = x+a, x+a, x+a, x+a
time = 40
[Command]  ;
name = "hakusai"
command = z, z, z, z
time = 40
[Command]  ;
name = "hakusai"
command = x, y, x, y, x, y
time = 40
[Command]  ;
name = "hakusai"
command = y, x, y, x, y, x
time = 40

[Command]  ;グリューネシルト
name = "Grunen_Schild"
command = x+y
[Command]  ;
name = "Grunen_Schild"
command = x+a
[Command]  ;
name = "Grunen_Schild"
command = z


[Command]  ;サマーソルベー・ネルクス
name = "somersolvay_nelux"
command = $D, $U, a+b
time = 15
[Command]  ;
name = "somersolvay_nelux"
command = $D, $U, y+b
time = 15
[Command]  ;
name = "somersolvay_nelux"
command = $D, $U, c
time = 15

[Command]  ;スーパーゲート
name = "super_gate"
command = $U, ~$U, $U, x+y
time = 30
[Command]  ;
name = "super_gate"
command = $U, ~$U, $U, x+a
time = 30
[Command]  ;
name = "super_gate"
command = $U, ~$U, $U, z
time = 30


;-| Special Motions |------------------------------------------------------

[Command]  ;UBS
name = "UBS_b"
command = D,$F,U,$B, b
time = 60
[Command]
name = "UBS_a"
command = D,$F,U,$B, a
time = 60
[Command]
name = "UBS_b"
command = D,$B,U,$F, b
time = 60
[Command]
name = "UBS_a"
command = D,$B,U,$F, a
time = 60

[Command]  ;UBS
name = "UBS_b"
command = F,$U,B,$D, b
time = 60
[Command]
name = "UBS_a"
command = F,$U,B,$D, a
time = 60
[Command]
name = "UBS_b"
command = F,$D,B,$U, b
[Command]
name = "UBS_a"
command = F,$D,B,$U, a

[Command]  ;UBS
name = "UBS_b"
command = U,$B,D,$F, b
time = 60
[Command]
name = "UBS_a"
command = U,$B,D,$F, a
time = 60
[Command]
name = "UBS_b"
command = U,$F,D,$B, b
time = 60
[Command]
name = "UBS_a"
command = U,$F,D,$B, a
time = 60

[Command]  ;UBS
name = "UBS_b"
command = B,$D,F,$U, b
time = 60
[Command]
name = "UBS_a"
command = B,$D,F,$U, a
time = 60
[Command]
name = "UBS_a"
command = B,$U,F,$D, b
time = 60
[Command]
name = "UBS_b"
command = B,$U,F,$D, a
time = 60



[Command]  ;禁酒法7
name = "seagram_z7"
command = ~1332z
[Command]  ;
name = "seagram_z7"
command = ~1332y
[Command]  ;
name = "seagram_z7"
command = ~1332x

[Command]  ;禁酒法6
name = "seagram_z6"
command = ~934z
[Command]  ;
name = "seagram_z6"
command = ~934y
[Command]  ;
name = "seagram_z6"
command = ~934x

[Command]  ;禁酒法5
name = "seagram_z5"
command = ~674z
[Command]  ;
name = "seagram_z5"
command = ~674y
[Command]  ;
name = "seagram_z5"
command = ~674x

[Command]  ;禁酒法4
name = "seagram_z4"
command = ~454z
[Command]  ;
name = "seagram_z4"
command = ~454y
[Command]  ;
name = "seagram_z4"
command = ~454x

[Command]  ;禁酒法3
name = "seagram_z3"
command = ~274z
[Command]  ;
name = "seagram_z3"
command = ~274y
[Command]  ;
name = "seagram_z3"
command = ~274x

[Command]  ;禁酒法2
name = "seagram_z2"
command = ~134z
[Command]  ;
name = "seagram_z2"
command = ~134y
[Command]  ;
name = "seagram_z2"
command = ~134x

[Command]  ;禁酒法1
name = "seagram_z1"
command = ~54z
[Command]  ;
name = "seagram_z1"
command = ~54y
[Command]  ;
name = "seagram_z1"
command = ~54x

[Command]  ;口からメロン
name = "melon_is_shot_y"
command = ~28$D, $U, y
time = 50
[Command]
name = "melon_is_shot_x"
command = ~28$D, $U, x
time = 50

[Command]  ;百裂ってる張り手
name = "put_a_label_y"
command = y, y, y, y
time = 40
[Command]
name = "put_a_label_x"
command = x, x, x, x
time = 40


[Command]  ;サマーソルト・シェルバーン
name = "somersault_shell_burn_b"
command = $D, $U, b
time = 15

[Command]  ;サマーソルト・シェルバーン
name = "somersault_shell_burn_a"
command = $D, $U, a
time = 15

[Command]  ;スターゲート
name = "star_gate_y"
command = $U, ~$U, $U, y
time = 30

[Command]  ;スターゲート
name = "star_gate_x"
command = $U, ~$U, $U, x
time = 30


[Command]  ;エリアル
name = "ariel_jump"
command = ~U, $U
time = 30

[Command]  ;
name = "x+a"
command = x+a
time = 10

[Command]  ;
name = "y+b"
command = y+b
time = 10

[Command]  ;
name = "5x+a"
command = $D,~$D,x+a
time = 10

[Command]  ;
name = "2x+a"
command = $D,x+a
time = 10


[Command] ;離すコマンド
name = "zannen2"
command = ~a
time = 10

;-| Double Tap |-----------------------------------------------------------

[Command]
name = "FF"     ;Required (do not remove)
command = F, F
time = 30

[Command]
name = "BB"     ;Required (do not remove)
command = B, B
time = 30

;-| 2/3 Button Combination |-----------------------------------------------
[Command]
name = "recovery";Required (do not remove)
command = x+y
time = 1

;-| Dir + Button |---------------------------------------------------------
[Command]
name = "down_a"
command = /$D,a
time = 1

[Command]
name = "down_b"
command = /$D,b
time = 1

;-| Single Button |---------------------------------------------------------
[Command]
name = "a"
command = a
time = 1

[Command]
name = "b"
command = b
time = 1

[Command]
name = "c"
command = c
time = 1

[Command]
name = "x"
command = x
time = 1

[Command]
name = "y"
command = y
time = 1

[Command]
name = "z"
command = z
time = 1

[Command]
name = "start"
command = s
time = 1

;-| Hold Dir |--------------------------------------------------------------
[Command]
name = "holdfwd";Required (do not remove)
command = /$F
time = 1

[Command]
name = "holdback";Required (do not remove)
command = /$B
time = 1

[Command]
name = "holdup" ;Required (do not remove)
command = /$U
time = 1

[Command]
name = "holddown";Required (do not remove)
command = /$D
time = 1

;---------------------------------------------------------------------------
; 2. State entry
; --------------

; Don't remove the following line. It's required by the CMD standard.
; ステートdef -1定義
[Statedef -1]

;===========================================================================
;上で設定したキー入力が出せる条件
;---------------------------------------------------------------------------


;===========================================================================
;変数var(1)必殺技(キャンセル技)可能な状態の指定

[State -1, Combo condition Reset]
type = VarSet
trigger1 = 1
var(1) = 0

[State -1, Combo condition Check]
type = VarSet
trigger1 = (stateno = [200,399]) || (stateno = [400,599]) ;立ちとしゃがみの通常技
trigger1 = stateno != 590 ;指定範囲内でキャンセルさせたくない技
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム数
trigger2 = stateno = 40 && AILevel = 0 ;ジャンプの根元
trigger3 = stateno = 52 && AILevel = 0 ;ジャンプの着地
trigger4 = stateno = 1441 || stateno = 1442 || stateno = 1443 ;ジャンプの根元
trigger4 = AILevel = 0 ;ジャンプの根元
var(1) = 1

[State -1, Combo condition Checkスパキャン]
type = VarSet
trigger1 = (stateno = [1000,1149]) || (stateno = [2000,2149]) ;スパキャン
trigger1 = stateno != 590 ;指定範囲内でキャンセルさせたくない技
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム数
trigger2 = (stateno = [2000,2050]) || (stateno = [1000,1005]) ;飛び道具
trigger2 = AnimElemTime(6) >= 1 && AnimElemTime(19) < 1   ;スパキャン
trigger2 = p2movetype = H ;とにかく相手がくらってる時
var(1) = 2



;---------------------------------------------------------------------------超必殺技
;---------------------------------------------------------------------------
[State -1, FRB8]
type = ChangeState
value = 3152
triggerall = power >= 1000
triggerall = command = "FRB_a" || command = "FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
triggerall = command = "holdup" 
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, FRB2]
type = ChangeState
value = 3156
triggerall = power >= 1000
triggerall = command = "FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, FRB6]
type = ChangeState
value = 3155
triggerall = power >= 1000
triggerall = command = "FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, FRB2]
type = ChangeState
value = 3151
triggerall = power >= 1000
triggerall = command = "FRB_a" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, FRB6]
type = ChangeState
value = 3150
triggerall = power >= 1000
triggerall = command = "FRB_a" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, HAARP]
type = ChangeState
value = 3050
triggerall = power >= 1000
triggerall = Numhelper(1910) > 0
triggerall = command = "5252y+b" || (NumHelper(10000)&&Helper(10000),Var(0)=3050 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) > 0 ;Use combo condition (above)スパキャン
;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, プロトンアーク]
type = ChangeState
value = 3000
triggerall = power >= 1000
triggerall = command = "5252x+a" || command = "5252y+b" && Numhelper(1910) = 0 || (NumHelper(10000)&&Helper(10000),Var(0)=3000 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) > 0 ;Use combo condition (above)スパキャン

;---------------------------------------------------------------------------空中超必殺技
;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, 地獄のピラミッド]
type = ChangeState
value = 3500
triggerall = power >= 1000
triggerall = command = "5252x+a" || command = "5252y+b" && Numhelper(1910) = 0 || (NumHelper(10000)&&Helper(10000),Var(0)=3500 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) >0 ;スパキャン

;---------------------------------------------------------------------------EX必殺技
;---------------------------------------------------------------------------

[State -1, MK_ultra8]
type = ChangeState
value = 2152
triggerall = power >= 1000
triggerall = command = "MK_ultra" || (NumHelper(10000)&&Helper(10000),Var(0)=2150 && Helper(10000),Var(1)>0)
triggerall = command = "holdup" 
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, MK_ultra2]
type = ChangeState
value = 2156
triggerall = power >= 1000
triggerall = command = "MK_ultra" || (NumHelper(10000)&&Helper(10000),Var(0)=2150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, MK_ultra6]
type = ChangeState
value = 2155
triggerall = power >= 1000
triggerall = command = "MK_ultra" || (NumHelper(10000)&&Helper(10000),Var(0)=2150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------

; (uses one super bar)
[State -1, ブルービーム]
type = ChangeState
value = 2000
triggerall = power >= 1000
triggerall = command = "blue_beam" || (NumHelper(10000)&&Helper(10000),Var(0)=2000 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) > 0 ;Use combo condition (above)スパキャン

;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, これはキャベツです。]
type = ChangeState
value = 2050
triggerall = power >= 1000
triggerall = command = "hakusai" || (NumHelper(10000)&&Helper(10000),Var(0)=2050 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) > 0 ;Use combo condition (above)スパキャン

;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, グリューネシルト]
type = ChangeState
value = 2110
triggerall = power >= 1000
triggerall = command = "Grunen_Schild"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = [1100,1106] ;seagram
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------空中EX必殺技
;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, スーパーゲート]
type = ChangeState
value = 2550
triggerall = power >= 1000
triggerall = command = "super_gate" || (NumHelper(10000)&&Helper(10000),Var(0)=2550 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) >0 ;スパキャン

;---------------------------------------------------------------------------
; (uses one super bar)
[State -1, サマーソルベー・ネルクス]
type = ChangeState
value = 2500
triggerall = power >= 1000
triggerall = command = "somersolvay_nelux" || (NumHelper(10000)&&Helper(10000),Var(0)=2500 && Helper(10000),Var(1)>0)
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) >0 ;スパキャン



;---------------------------------------------------------------------------必殺技
;---------------------------------------------------------------------------
[State -1, UBS8]
type = ChangeState
value = 1152
triggerall = command = "UBS_a" || command = "UBS_b" || (NumHelper(10000)&&Helper(10000),Var(0)=1150 && Helper(10000),Var(1)>0)
triggerall = command = "holdup" 
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, UBS2]
type = ChangeState
value = 1156
triggerall = command = "UBS_b" || (NumHelper(10000)&&Helper(10000),Var(0)=1155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, UBS6]
type = ChangeState
value = 1155
triggerall = command = "UBS_b" || (NumHelper(10000)&&Helper(10000),Var(0)=1155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, UBS2]
type = ChangeState
value = 1151
triggerall = command = "UBS_a" || (NumHelper(10000)&&Helper(10000),Var(0)=1150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A

;---------------------------------------------------------------------------
[State -1, UBS6]
type = ChangeState
value = 1150
triggerall = command = "UBS_a" || (NumHelper(10000)&&Helper(10000),Var(0)=1150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A


;---------------------------------------------------------------------------
[State -1, 禁酒法7]
type = ChangeState
value = 1106
triggerall = command = "seagram_z7" || (NumHelper(10000)&&Helper(10000),Var(0)=1106 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法6]
type = ChangeState
value = 1105
triggerall = command = "seagram_z6" || (NumHelper(10000)&&Helper(10000),Var(0)=1105 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法5]
type = ChangeState
value = 1104
triggerall = command = "seagram_z5" || (NumHelper(10000)&&Helper(10000),Var(0)=1104 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法4]
type = ChangeState
value = 1103
triggerall = command = "seagram_z4" || (NumHelper(10000)&&Helper(10000),Var(0)=1103 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法3]
type = ChangeState
value = 1102
triggerall = command = "seagram_z3" || (NumHelper(10000)&&Helper(10000),Var(0)=1102 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法2]
type = ChangeState
value = 1101
triggerall = command = "seagram_z2" || (NumHelper(10000)&&Helper(10000),Var(0)=1101 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 禁酒法1]
type = ChangeState
value = 1100
triggerall = command = "seagram_z1" || (NumHelper(10000)&&Helper(10000),Var(0)=1100 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, NXIVM]
type = ChangeState
value = 1110
triggerall = command = "y"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = [1100,1106] ;seagram
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
[State -1, 秘密結社DOS]
type = ChangeState
value = 1120
triggerall = command = "x"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = [1100,1106] ;seagram
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
[State -1, 口からメロン大]
type = ChangeState
value = 1005
triggerall = command = "melon_is_shot_y" || (NumHelper(10000)&&Helper(10000),Var(0)=1005 && Helper(10000),Var(1)>0)
triggerall = Numhelper(1010) = 0
triggerall = Numhelper(1015) = 0
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, 口からメロン小]
type = ChangeState
value = 1000
triggerall = command = "melon_is_shot_x" || (NumHelper(10000)&&Helper(10000),Var(0)=1000 && Helper(10000),Var(1)>0)
triggerall = Numhelper(1010) = 0   ;飛び道具(helper1010)のある時は出ない
triggerall = Numhelper(1015) = 0
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, 百裂ってる張り手大]
type = ChangeState
value = 1060
triggerall = command = "put_a_label_y" || (NumHelper(10000)&&Helper(10000),Var(0)=1060 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, 百裂ってる張り手小]
type = ChangeState
value = 1050
triggerall = command = "put_a_label_x" || (NumHelper(10000)&&Helper(10000),Var(0)=1050 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) = 1 ;Use combo condition (above)


;---------------------------------------------------------------------------空中必殺技
;---------------------------------------------------------------------------
[State -1, スターゲート大]
type = ChangeState
value = 1560
triggerall = command = "star_gate_y"
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) =1 ;キャンセル

;---------------------------------------------------------------------------
[State -1, スターゲート小]
type = ChangeState
value = 1550
triggerall = command = "star_gate_x"
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) =1 ;キャンセル

;---------------------------------------------------------------------------
[State -1, サマーソルト・シェルバーン大]
type = ChangeState
value = 1510
triggerall = command = "somersault_shell_burn_b"
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) =1 ;キャンセル

;---------------------------------------------------------------------------
[State -1, サマーソルト・シェルバーン小]
type = ChangeState
value = 1500
triggerall = command = "somersault_shell_burn_a"
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = var(18) =1 ;キャンセル

;---------------------------------------------------------------------------特殊技
;---------------------------------------------------------------------------
[State -1, ちからバール]
type = ChangeState
value = 1400
triggerall = command = "y+b" || (NumHelper(10000)&&Helper(10000),Var(0)=1400 && Helper(10000),Var(1)>0)
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype != A
trigger2 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, c肉や!]
type = ChangeState
value = 1410
triggerall = command = "5x+a"
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, c気分ため]
type = ChangeState
value = 1420
triggerall = command = "2x+a"
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
trigger1 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, 肉や!]
type = ChangeState
value = 1410
triggerall = command = "x+a" || command = "5x+a" || command = "start" || (NumHelper(10000)&&Helper(10000),Var(0)=1410 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = S
trigger2 = var(1) ;Use combo condition (above)

;---------------------------------------------------------------------------
[State -1, 気分ため]
type = ChangeState
value = 1420
triggerall = command = "x+a" || command = "2x+a" || command = "start" || (NumHelper(10000)&&Helper(10000),Var(0)=1420 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = C
trigger2 = var(1) ;Use combo condition (above)
;---------------------------------------------------------------------------
[State -1, 移動起き上がり6]
type = ChangeState
value = 1432
triggerall = command = "x+a"
triggerall = command = "holdfwd"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = 5110 ;
;---------------------------------------------------------------------------
[State -1, 移動起き上がり4]
type = ChangeState
value = 1430
triggerall = command = "x+a"
triggerall = command = "holdback"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = 5110 ;
;---------------------------------------------------------------------------
[State -1, 移動起き上がり5]
type = ChangeState
value = 1431
triggerall = command = "x+a"
TriggerAll = Alive && var(59) < 1
trigger1 = stateno = 5110 ;

;---------------------------------------------------------------------------起必殺技
;---------------------------------------------------------------------------
[State -1, intiki_FRB8]
type = ChangeState
value = 3152
triggerall = power >= 1000
triggerall = command = "intiki_FRB_a" || command = "intiki_FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
triggerall = command = "holdup" 
TriggerAll = StateType != A
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, intiki_FRB2]
type = ChangeState
value = 3156
triggerall = power >= 1000
triggerall = command = "intiki_FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, intiki_FRB6]
type = ChangeState
value = 3155
triggerall = power >= 1000
triggerall = command = "intiki_FRB_b" || (NumHelper(10000)&&Helper(10000),Var(0)=3155 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, intiki_FRB2]
type = ChangeState
value = 3151
triggerall = power >= 1000
triggerall = command = "intiki_FRB_a" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = C
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------
[State -1, intiki_FRB6]
type = ChangeState
value = 3150
triggerall = power >= 1000
triggerall = command = "intiki_FRB_a" || (NumHelper(10000)&&Helper(10000),Var(0)=3150 && Helper(10000),Var(1)>0)
TriggerAll = StateType = S
TriggerAll = Alive && var(59) < 1
Trigger1 = PrevStateNo = 5120
trigger2 = var(56) = [5192,5200]

;---------------------------------------------------------------------------空中特殊技
;---------------------------------------------------------------------------
[State -1, ケムトレイル]
type = ChangeState
value = 1900
triggerall = command = "x+a"
TriggerAll = Alive && var(59) < 1
trigger1 = ctrl && statetype = A 
trigger2 = stateno=600 || stateno=610 || stateno= 630 || stateno= 640 || stateno= 650 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 601 || stateno = 631 ;通常技キャンセル
trigger3 = p2movetype=H || p2stateno=[150,155] ;なんか当たってそうな時
trigger3 = time < 15 ;キャンセル可能なフレーム

;---------------------------------------------------------------------------特殊技
;---------------------------------------------------------------------------

[State -1, ガードキャンセル]
type = ChangeState
value = 1960
TriggerAll = Alive && var(59) < 1
triggerall = command = "y+b" 
triggerall = statetype != A
triggerall = power >= 1000
trigger1 = stateno = [140,155]
trigger1 = time < 14

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;Run Fwd
[State -1, Run Fwd]
type = ChangeState
value = 100
trigger1 = command = "FF"
trigger1 = statetype = S
trigger1 = ctrl
;---------------------------------------------------------------------------
;Run Back
[State -1, Run Back]
type = ChangeState
value = 105
TriggerAll = Alive && var(59) < 1
trigger1 = command = "BB"
trigger1 = statetype = S
trigger1 = ctrl

;---------------------------------------------------------------------------
;Kung Fu Throw
[State -1, Kung Fu Throw]   ;投げ6
type = ChangeState
value = 800
triggerall = command = "y"   ;大パンチ
triggerall = ctrl && statetype = S
triggerall = stateno != 100   ;ダッシュ時不可
triggerall = p2bodydist X < 24   ;コマンド上での投げ間合い
triggerall = (p2statetype = S) || (p2statetype = C)
triggerall = p2movetype != H || (p2stateno != [150,153]) || p2stateno != [5000,5300]
TriggerAll = Alive && var(59) < 1
trigger1 = command = "holdfwd"   ;前歩き

;---------------------------------------------------------------------------
;Kung Fu Throw
[State -1, Kung Fu Throw]   ;投げ4
type = ChangeState
value = 825
triggerall = command = "y"   ;大パンチ
triggerall = ctrl && statetype = S
triggerall = stateno != 100   ;ダッシュ時不可
triggerall = p2bodydist X < 24   ;コマンド上での投げ間合い
triggerall = (p2statetype = S) || (p2statetype = C)
triggerall = p2movetype != H || (p2stateno != [150,153]) || p2stateno != [5000,5300]
TriggerAll = Alive && var(59) < 1
trigger1 = command = "holdback"   ;後ろ歩き

;---------------------------------------------------------------------------
;Kung Fu Throw
[State -1, Kung Fu Throw]   ;空中投げ
type = ChangeState
value = 900
triggerall = command = "y"   ;大パンチ
triggerall = statetype = A
triggerall = ctrl
TriggerAll = Alive && var(59) < 1
trigger1 = command = "holdfwd" || command = "holdback"
trigger1 = p2bodydist X < 24   ;コマンド上での投げ間合い
trigger1 = p2statetype = A
trigger1 = p2movetype != H || p2stateno != [120,155]

;===========================================================================
;---------------------------------------------------------------------------
;---------------------------------------------------------------------------

;Stand Light Punch
[State -1, Stand Light Punch]
type = ChangeState
value = 200
triggerall = command = "x"
triggerall = command != "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;連打キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 240 || stateno = 440 ;通常技キャンセル
trigger3 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Stand Strong Punch
[State -1, Stand Strong Punch]
type = ChangeState
value = 210
triggerall = command = "y"
triggerall = command != "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Stand Light Kick
[State -1, Stand Light Kick]
type = ChangeState
value = 230
triggerall = command = "a"
triggerall = command != "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;連打キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Standing Strong Kick
[State -1, Standing Strong Kick]
type = ChangeState
value = 240
triggerall = command = "b"
triggerall = command != "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = S
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 210 || stateno = 410 ;通常技キャンセル
trigger3 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;Crouching Light Punch
[State -1, Crouching Light Punch]
type = ChangeState
value = 400
triggerall = command = "x"
triggerall = command = "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;連打キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 240 || stateno = 440 ;通常技キャンセル
trigger3 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Crouching Strong Punch
[State -1, Crouching Strong Punch]
type = ChangeState
value = 410
triggerall = command = "y"
triggerall = command = "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Crouching Light Kick
[State -1, Crouching Light Kick]
type = ChangeState
value = 430
triggerall = command = "a"
triggerall = command = "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;連打キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Crouching Strong Kick
[State -1, Crouching Strong Kick]
type = ChangeState
value = 440
triggerall = command = "b"
triggerall = command = "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = C
trigger1 = ctrl
trigger2 = stateno = 200 || stateno = 230 || stateno = 400 || stateno = 430 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 210 || stateno = 410 ;通常技キャンセル
trigger3 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------
;Jump 2Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 650
triggerall = command = "b"
triggerall = command = "holddown"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 610 || stateno = 630 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 601 || stateno = 631 ;通常技キャンセル
trigger3 = p2movetype=H || p2stateno=[150,155] ;なんか当たってそうな時
trigger3 = time < 15 ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Jump Light Punch
[State -1, Jump Light Punch]
type = ChangeState
value = 600
triggerall = command = "x"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 640 || stateno = 650 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Jump Strong Punch
[State -1, Jump Strong Punch]
type = ChangeState
value = 610
triggerall = command = "y"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 630 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 601 || stateno = 631 ;通常技キャンセル
trigger3 = p2movetype=H || p2stateno=[150,155] ;なんか当たってそうな時
trigger3 = time < 15 ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Jump Light Kick
[State -1, Jump Light Kick]
type = ChangeState
value = 630
triggerall = command = "a"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 601 || stateno = 631 ;通常技キャンセル
trigger3 = p2movetype=H || p2stateno=[150,155] ;なんか当たってそうな時
trigger3 = time < 15 ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;Jump Strong Kick
[State -1, Jump Strong Kick]
type = ChangeState
value = 640
triggerall = command = "b"
TriggerAll = Alive && var(59) < 1
trigger1 = statetype = A
trigger1 = ctrl
trigger2 = stateno = 600 || stateno = 610 || stateno = 630 ;通常技キャンセル
trigger2 = movecontact = [1,14] ;キャンセル可能なフレーム
trigger3 = stateno = 601 || stateno = 631 ;通常技キャンセル
trigger3 = p2movetype=H || p2stateno=[150,155] ;なんか当たってそうな時
trigger3 = time < 15 ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;---------------------------------------------------------------------------キャンセルジャンプ
;前ジャンプ
[State -1, 前ジャンプ]
type = ChangeState
value = 1441
triggerall = command ="holdup"
triggerall = command ="holdfwd"
trigger1 = stateno = 210 || stateno = 410 ;通常技キャンセル
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム

;---------------------------------------------------------------------------
;後ジャンプ
[State -1, 後ジャンプ]
type = ChangeState
value = 1442
triggerall = command ="holdup"
triggerall = command ="holdback"
trigger1 = stateno = 210 || stateno = 410 ;通常技キャンセル
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム
;---------------------------------------------------------------------------
;ジャンプ
[State -1, ジャンプ]
type = ChangeState
value = 1443
triggerall = command ="holdup"
trigger1 = stateno = 210 || stateno = 410 ;通常技キャンセル
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム
;---------------------------------------------------------------------------
;AirJump
[State -1, AirJump]
type = ChangeState
value = 1445
triggerall = command ="ariel_jump"
trigger1 = stateno = 610 ;通常技キャンセル
trigger1 = movecontact = [1,14] ;キャンセル可能なフレーム