// ==UserScript==
// @name         LLM Proxy Token Grabber v3.1
// @namespace    http://tampermonkey.net/
// @version      3.1
// @description  Captures authorization tokens and sends to local proxy
// @author       You
// @match        https://theoldllm.vercel.app/*
// @grant        GM_xmlhttpRequest
// @grant        GM_notification
// @grant        GM_setValue
// @grant        GM_getValue
// @grant        unsafeWindow
// @connect      localhost
// @connect      127.0.0.1
// @run-at       document-start
// ==/UserScript==

(function() {
    'use strict';

    // ============================================
    // CONFIGURATION
    // ============================================
    const CONFIG = {
        proxyUrl: 'http://localhost:8001/receive-token',
        debug: true,
        showUI: true
    };

    let lastSentToken = '';

    function log(...args) {
        if (CONFIG.debug) {
            console.log('%c[TokenGrabber]', 'color: #00ff00; font-weight: bold; background: #000; padding: 2px 5px;', ...args);
        }
    }

    function logError(...args) {
        console.error('%c[TokenGrabber ERROR]', 'color: #ff0000; font-weight: bold; background: #000; padding: 2px 5px;', ...args);
    }

    // ============================================
    // Token Sending
    // ============================================
    function sendToken(token, source) {
        if (!token) {
            log('⚠️ Empty token, skipping');
            return;
        }

        // Normalize
        token = token.trim();
        if (!token.startsWith('Bearer ')) {
            token = 'Bearer ' + token;
        }

        // Skip duplicates
        if (token === lastSentToken) {
            log('⏭️ Token unchanged, skipping');
            return;
        }

        log(`📤 Sending token (source: ${source})`);
        log(`   Token: ${token.substring(0, 60)}...`);

        const payload = JSON.stringify({
            token: token,
            source: source,
            timestamp: Date.now(),
            url: window.location.href
        });

        log(`   Payload: ${payload.substring(0, 100)}...`);
        log(`   Sending to: ${CONFIG.proxyUrl}`);

        GM_xmlhttpRequest({
            method: 'POST',
            url: CONFIG.proxyUrl,
            headers: {
                'Content-Type': 'application/json',
                'Accept': 'application/json'
            },
            data: payload,
            onload: function(response) {
                log(`   Response status: ${response.status}`);
                log(`   Response body: ${response.responseText}`);

                if (response.status === 200) {
                    log('✅ Token sent successfully!');
                    lastSentToken = token;
                    GM_setValue('lastToken', token);
                    updateUI('success', 'Token sent!');

                    try {
                        GM_notification({
                            title: '🔐 Token Captured',
                            text: `Source: ${source}`,
                            timeout: 2000
                        });
                    } catch(e) {}
                } else {
                    logError(`Failed: ${response.status} - ${response.responseText}`);
                    updateUI('error', `Error: ${response.status}`);
                }
            },
            onerror: function(error) {
                logError('Request failed:', error);
                logError('Make sure the proxy server is running on port 8001');
                updateUI('error', 'Connection failed');
            },
            ontimeout: function() {
                logError('Request timeout');
                updateUI('error', 'Timeout');
            }
        });
    }

    // ============================================
    // Token Extraction
    // ============================================
    function extractToken() {
        let token = null;

        // Method 1: localStorage
        try {
            for (let i = 0; i < localStorage.length; i++) {
                const key = localStorage.key(i);
                const value = localStorage.getItem(key);
                if (value && typeof value === 'string' && value.includes('on_tenant_')) {
                    log(`Found in localStorage[${key}]`);
                    token = value;
                    break;
                }
            }
        } catch (e) {
            logError('localStorage error:', e);
        }

        // Method 2: sessionStorage
        if (!token) {
            try {
                for (let i = 0; i < sessionStorage.length; i++) {
                    const key = sessionStorage.key(i);
                    const value = sessionStorage.getItem(key);
                    if (value && typeof value === 'string' && value.includes('on_tenant_')) {
                        log(`Found in sessionStorage[${key}]`);
                        token = value;
                        break;
                    }
                }
            } catch (e) {
                logError('sessionStorage error:', e);
            }
        }

        // Method 3: cookies
        if (!token) {
            try {
                document.cookie.split(';').forEach(cookie => {
                    const [name, ...valueParts] = cookie.trim().split('=');
                    const value = valueParts.join('=');
                    if (value && value.includes('on_tenant_')) {
                        log(`Found in cookie[${name}]`);
                        token = decodeURIComponent(value);
                    }
                });
            } catch (e) {
                logError('cookie error:', e);
            }
        }

        return token;
    }

    // ============================================
    // Request Interceptors
    // ============================================
    function interceptXHR() {
        const originalOpen = XMLHttpRequest.prototype.open;
        const originalSetRequestHeader = XMLHttpRequest.prototype.setRequestHeader;

        XMLHttpRequest.prototype.open = function(method, url) {
            this._url = url;
            return originalOpen.apply(this, arguments);
        };

        XMLHttpRequest.prototype.setRequestHeader = function(name, value) {
            if (name && name.toLowerCase() === 'authorization') {
                if (value && typeof value === 'string' && value.includes('on_tenant_')) {
                    log('🎯 XHR Authorization header intercepted');
                    log(`   URL: ${this._url}`);
                    sendToken(value, 'xhr');
                }
            }
            return originalSetRequestHeader.apply(this, arguments);
        };

        log('✅ XHR interceptor installed');
    }

    function interceptFetch() {
        const originalFetch = unsafeWindow.fetch;

        unsafeWindow.fetch = function(url, options) {
            // Extract auth header
            if (options && options.headers) {
                let authHeader = null;

                if (options.headers instanceof Headers) {
                    authHeader = options.headers.get('Authorization');
                } else if (typeof options.headers === 'object') {
                    // Handle both cases
                    authHeader = options.headers['Authorization'] ||
                                 options.headers['authorization'] ||
                                 options.headers.authorization;
                }

                if (authHeader && typeof authHeader === 'string' && authHeader.includes('on_tenant_')) {
                    log('🎯 Fetch Authorization header intercepted');
                    log(`   URL: ${url}`);
                    sendToken(authHeader, 'fetch');
                }
            }

            return originalFetch.apply(this, arguments);
        };

        log('✅ Fetch interceptor installed');
    }

    // ============================================
    // Storage Monitor
    // ============================================
    function startMonitor() {
        log('Starting token monitor...');

        setInterval(() => {
            const token = extractToken();
            if (token && token !== lastSentToken) {
                log('🔍 Monitor found new token');
                sendToken(token, 'monitor');
            }
        }, 3000);

        log('✅ Token monitor started (3s interval)');
    }

    // ============================================
    // UI
    // ============================================
    function updateUI(status, message) {
        const statusEl = document.getElementById('tg-status');
        const indicator = document.getElementById('tg-indicator');

        if (statusEl) statusEl.textContent = message;
        if (indicator) {
            indicator.style.background =
                status === 'success' ? '#00ff00' :
                status === 'error' ? '#ff0000' : '#ffff00';
        }
    }

    function createUI() {
        if (!CONFIG.showUI) return;

        // Wait for body
        if (!document.body) {
            setTimeout(createUI, 100);
            return;
        }

        const container = document.createElement('div');
        container.id = 'token-grabber-ui';
        container.innerHTML = `
            <style>
                #token-grabber-ui {
                    position: fixed;
                    bottom: 20px;
                    right: 20px;
                    z-index: 2147483647;
                    font-family: -apple-system, sans-serif;
                }
                #tg-toggle {
                    width: 50px;
                    height: 50px;
                    border-radius: 50%;
                    background: linear-gradient(135deg, #667eea, #764ba2);
                    border: none;
                    cursor: pointer;
                    box-shadow: 0 4px 15px rgba(0,0,0,0.3);
                    font-size: 20px;
                    position: relative;
                    transition: transform 0.2s;
                }
                #tg-toggle:hover { transform: scale(1.1); }
                #tg-indicator {
                    position: absolute;
                    top: -2px;
                    right: -2px;
                    width: 14px;
                    height: 14px;
                    border-radius: 50%;
                    background: #ffff00;
                    border: 2px solid white;
                    box-shadow: 0 2px 5px rgba(0,0,0,0.2);
                }
                #tg-panel {
                    display: none;
                    position: absolute;
                    bottom: 60px;
                    right: 0;
                    width: 300px;
                    background: #1a1a2e;
                    border-radius: 12px;
                    box-shadow: 0 10px 40px rgba(0,0,0,0.3);
                    overflow: hidden;
                    color: white;
                }
                #tg-panel.show { display: block; }
                #tg-header {
                    background: linear-gradient(135deg, #667eea, #764ba2);
                    padding: 12px 15px;
                    font-weight: bold;
                }
                #tg-body { padding: 15px; }
                #tg-status {
                    background: rgba(255,255,255,0.1);
                    padding: 10px;
                    border-radius: 6px;
                    font-size: 12px;
                    margin-bottom: 10px;
                }
                #tg-preview {
                    font-family: monospace;
                    font-size: 9px;
                    background: rgba(0,0,0,0.3);
                    padding: 10px;
                    border-radius: 6px;
                    word-break: break-all;
                    max-height: 60px;
                    overflow: auto;
                    margin-bottom: 10px;
                }
                #tg-btn {
                    width: 100%;
                    padding: 10px;
                    background: #667eea;
                    color: white;
                    border: none;
                    border-radius: 6px;
                    cursor: pointer;
                    font-weight: bold;
                }
                #tg-btn:hover { background: #5a6fd6; }
                #tg-info {
                    font-size: 10px;
                    color: rgba(255,255,255,0.5);
                    margin-top: 10px;
                    text-align: center;
                }
            </style>
            <div id="tg-panel">
                <div id="tg-header">🔐 Token Grabber v3.1</div>
                <div id="tg-body">
                    <div id="tg-status">Waiting for token...</div>
                    <div id="tg-preview">No token yet</div>
                    <button id="tg-btn">⚡ Force Capture & Send</button>
                    <div id="tg-info">Proxy: localhost:8001</div>
                </div>
            </div>
            <button id="tg-toggle">🔑<span id="tg-indicator"></span></button>
        `;

        document.body.appendChild(container);

        // Toggle panel
        document.getElementById('tg-toggle').addEventListener('click', () => {
            document.getElementById('tg-panel').classList.toggle('show');
        });

        // Force capture button
        document.getElementById('tg-btn').addEventListener('click', () => {
            log('Manual capture triggered');
            const token = extractToken();
            if (token) {
                document.getElementById('tg-preview').textContent = token.substring(0, 80) + '...';
                sendToken(token, 'manual');
            } else {
                alert('No token found!\n\nTry making a request on the page first.');
                updateUI('error', 'No token found');
            }
        });

        // Update preview periodically
        setInterval(() => {
            const saved = GM_getValue('lastToken', '');
            if (saved) {
                document.getElementById('tg-preview').textContent = saved.substring(0, 80) + '...';
                updateUI('success', '✅ Token ready');
            }
        }, 2000);

        log('✅ UI created');
    }

    // ============================================
    // Initialize
    // ============================================
    function init() {
        log('🚀 Initializing Token Grabber v3.1');
        log(`   Target: ${CONFIG.proxyUrl}`);

        // Install interceptors IMMEDIATELY (before page loads)
        interceptXHR();
        interceptFetch();

        // Wait for DOM for UI and monitor
        if (document.readyState === 'loading') {
            document.addEventListener('DOMContentLoaded', () => {
                createUI();
                startMonitor();
            });
        } else {
            createUI();
            startMonitor();
        }

        // Initial scan after short delay
        setTimeout(() => {
            log('Running initial token scan...');
            const token = extractToken();
            if (token) {
                log('Found token on initial scan');
                sendToken(token, 'initial');
            } else {
                log('No token found on initial scan');
            }
        }, 2000);

        log('✅ Initialization complete');
    }

    // Start!
    init();
})();